/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.variantutils;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.tribble.TribbleException;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.DbsnpArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.GenomeLoc;
import org.broadinstitute.hellbender.utils.GenomeLocParser;
import org.broadinstitute.hellbender.utils.GenomeLocSortedSet;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Validates a VCF file with an extra strict set of criteria.", oneLineSummary="Validate VCF", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
public final class ValidateVariants
extends VariantWalker {
    static final Logger logger = LogManager.getLogger(ValidateVariants.class);
    public static final String GVCF_VALIDATE = "validate-GVCF";
    public static final String DO_NOT_VALIDATE_FILTERED_RECORDS = "do-not-validate-filtered-records";
    @ArgumentCollection
    DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Argument(fullName="validation-type-to-exclude", shortName="Xtype", doc="which validation type to exclude from a full strict validation", optional=true)
    List<ValidationType> excludeTypes = new ArrayList<ValidationType>();
    @Argument(fullName="do-not-validate-filtered-records", shortName="do-not-validate-filtered-records", doc="skip validation on filtered records", optional=true, mutex={"validate-GVCF"})
    Boolean DO_NOT_VALIDATE_FILTERED = false;
    @Argument(fullName="warn-on-errors", shortName="warn-on-errors", doc="just emit warnings on errors instead of terminating the run at the first instance", optional=true)
    Boolean WARN_ON_ERROR = false;
    @Argument(fullName="validate-GVCF", shortName="gvcf", doc="Validate this file as a GVCF", optional=true, mutex={"do-not-validate-filtered-records"})
    Boolean VALIDATE_GVCF = false;
    private Collection<ValidationType> validationTypes;
    private GenomeLocSortedSet genomeLocSortedSet;
    private SimpleInterval previousInterval;
    private int previousStart = -1;
    private String previousContig = null;

    @Override
    public void onTraversalStart() {
        if (this.VALIDATE_GVCF.booleanValue()) {
            SAMSequenceDictionary seqDictionary = this.getBestAvailableSequenceDictionary();
            if (seqDictionary == null) {
                throw new UserException("Validating a GVCF requires a sequence dictionary but no dictionary was able to be constructed from your input.");
            }
            this.genomeLocSortedSet = new GenomeLocSortedSet(new GenomeLocParser(seqDictionary));
        }
        this.validationTypes = this.calculateValidationTypesToApply(this.excludeTypes);
        if (this.dbsnp.dbsnp == null && (this.validationTypes.contains((Object)ValidationType.ALL) || this.validationTypes.contains((Object)ValidationType.IDS))) {
            logger.warn("IDS validation cannot be done because no DBSNP file was provided");
            logger.warn("Other possible validations will still be performed");
        }
        if (!this.hasReference() && (this.validationTypes.contains((Object)ValidationType.ALL) || this.validationTypes.contains((Object)ValidationType.REF))) {
            logger.warn("REF validation cannot be done because no reference file was provided");
            logger.warn("Other possible validations will still be performed");
        }
    }

    @Override
    public void apply(VariantContext vc, ReadsContext readsContext, ReferenceContext ref, FeatureContext featureContext) {
        if (this.DO_NOT_VALIDATE_FILTERED.booleanValue() && vc.isFiltered()) {
            return;
        }
        Allele reportedRefAllele = vc.getReference();
        int refLength = reportedRefAllele.length();
        Allele observedRefAllele = this.hasReference() ? Allele.create((byte[])Arrays.copyOf(ref.getBases(), refLength)) : null;
        Set<String> rsIDs = this.getRSIDs(featureContext);
        if (this.VALIDATE_GVCF.booleanValue()) {
            SimpleInterval refInterval = ref.getInterval();
            this.validateVariantsOrder(vc);
            int start = this.previousInterval != null && this.previousInterval.overlapsWithMargin(refInterval, 1) ? this.previousInterval.getStart() : refInterval.getStart();
            int end = this.previousInterval != null && this.previousInterval.overlapsWithMargin(refInterval, 1) ? Math.max(this.previousInterval.getEnd(), vc.getEnd()) : vc.getEnd();
            GenomeLoc possiblyMergedGenomeLoc = this.genomeLocSortedSet.getGenomeLocParser().createGenomeLoc(refInterval.getContig(), start, end);
            this.genomeLocSortedSet.add(possiblyMergedGenomeLoc, true);
            this.previousInterval = new SimpleInterval(possiblyMergedGenomeLoc);
            this.previousStart = vc.getStart();
            this.validateGVCFVariant(vc);
        }
        for (ValidationType t : this.validationTypes) {
            try {
                this.applyValidationType(vc, reportedRefAllele, observedRefAllele, rsIDs, t);
            }
            catch (TribbleException e) {
                this.throwOrWarn(new UserException.FailsStrictValidation(this.drivingVariantFile.getRawInputString(), t, e.getMessage()));
            }
        }
    }

    @Override
    public Object onTraversalSuccess() {
        if (this.VALIDATE_GVCF.booleanValue()) {
            SAMSequenceDictionary seqDictionary = this.getBestAvailableSequenceDictionary();
            GenomeLocSortedSet intervalArgumentGenomeLocSortedSet = this.intervalArgumentCollection.intervalsSpecified() ? GenomeLocSortedSet.createSetFromList(this.genomeLocSortedSet.getGenomeLocParser(), IntervalUtils.genomeLocsFromLocatables(this.genomeLocSortedSet.getGenomeLocParser(), this.intervalArgumentCollection.getIntervals(seqDictionary))) : GenomeLocSortedSet.createSetFromSequenceDictionary(seqDictionary);
            GenomeLocSortedSet uncoveredIntervals = intervalArgumentGenomeLocSortedSet.subtractRegions(this.genomeLocSortedSet);
            if (uncoveredIntervals.coveredSize() > 0L) {
                UserException e = new UserException("A GVCF must cover the entire region. Found " + uncoveredIntervals.coveredSize() + " loci with no VariantContext covering it. The first uncovered segment is:" + uncoveredIntervals.iterator().next());
                this.throwOrWarn(e);
            }
        }
        return null;
    }

    private Set<String> getRSIDs(FeatureContext featureContext) {
        LinkedHashSet<String> rsIDs = new LinkedHashSet<String>();
        for (VariantContext rsID : featureContext.getValues(this.dbsnp.dbsnp)) {
            rsIDs.addAll(Arrays.asList(rsID.getID().split(";")));
        }
        return rsIDs;
    }

    private Collection<ValidationType> calculateValidationTypesToApply(List<ValidationType> excludeTypes) {
        ArrayList<ValidationType> excludeTypesTemp = new ArrayList<ValidationType>(excludeTypes);
        if (this.VALIDATE_GVCF.booleanValue() && !excludeTypesTemp.contains((Object)ValidationType.ALLELES)) {
            logger.warn("GVCF format is currently incompatible with allele validation. Not validating Alleles.");
            excludeTypesTemp.add(ValidationType.ALLELES);
        }
        if (excludeTypesTemp.isEmpty()) {
            return Collections.singleton(ValidationType.ALL);
        }
        LinkedHashSet<ValidationType> excludeTypeSet = new LinkedHashSet<ValidationType>(excludeTypesTemp);
        if (excludeTypesTemp.size() != excludeTypeSet.size()) {
            logger.warn("found repeat redundant validation types listed using the --validation-type-to-exclude argument");
        }
        if (excludeTypeSet.contains((Object)ValidationType.ALL)) {
            if (excludeTypeSet.size() > 1) {
                logger.warn("found ALL in the --validation-type-to-exclude list together with other concrete type exclusions that are redundant");
            }
            return Collections.emptyList();
        }
        LinkedHashSet<ValidationType> result = new LinkedHashSet<ValidationType>(ValidationType.CONCRETE_TYPES);
        result.removeAll(excludeTypeSet);
        if (result.contains((Object)ValidationType.REF) && !this.hasReference()) {
            throw new UserException.MissingReference("Validation type " + ValidationType.REF.name() + " was selected but no reference was provided.", true);
        }
        return result;
    }

    private void validateVariantsOrder(VariantContext vc) {
        if (this.previousContig == null || !this.previousContig.equals(vc.getContig())) {
            this.previousContig = vc.getContig();
            this.previousStart = -1;
        }
        if (this.previousStart > -1 && vc.getStart() < this.previousStart) {
            UserException e = new UserException(String.format("In a GVCF all records must ordered. Record: %s covers a position previously traversed.", vc.toStringWithoutGenotypes()));
            this.throwOrWarn(e);
        }
    }

    private void validateGVCFVariant(VariantContext vc) {
        if (!vc.hasAllele(Allele.NON_REF_ALLELE)) {
            UserException e = new UserException(String.format("In a GVCF all records must contain a %s allele. Offending record: %s", "<NON_REF>", vc.toStringWithoutGenotypes()));
            this.throwOrWarn(e);
        }
    }

    private void applyValidationType(VariantContext vc, Allele reportedRefAllele, Allele observedRefAllele, Set<String> rsIDs, ValidationType t) {
        switch (t) {
            case ALL: {
                if (this.hasReference()) {
                    if (!rsIDs.isEmpty()) {
                        vc.extraStrictValidation(reportedRefAllele, observedRefAllele, rsIDs);
                        break;
                    }
                    vc.validateReferenceBases(reportedRefAllele, observedRefAllele);
                    vc.validateAlternateAlleles();
                    vc.validateChromosomeCounts();
                    break;
                }
                if (rsIDs.isEmpty()) {
                    vc.validateAlternateAlleles();
                    vc.validateChromosomeCounts();
                    break;
                }
                vc.validateAlternateAlleles();
                vc.validateChromosomeCounts();
                vc.validateRSIDs(rsIDs);
                break;
            }
            case REF: {
                vc.validateReferenceBases(reportedRefAllele, observedRefAllele);
                break;
            }
            case IDS: {
                if (rsIDs.isEmpty()) break;
                vc.validateRSIDs(rsIDs);
                break;
            }
            case ALLELES: {
                vc.validateAlternateAlleles();
                break;
            }
            case CHR_COUNTS: {
                vc.validateChromosomeCounts();
            }
        }
    }

    private void throwOrWarn(UserException e) {
        if (!this.WARN_ON_ERROR.booleanValue()) {
            throw e;
        }
        logger.warn("***** " + e.getMessage() + " *****");
    }

    public static enum ValidationType {
        ALL,
        REF,
        IDS,
        ALLELES,
        CHR_COUNTS;

        public static final Set<ValidationType> CONCRETE_TYPES;

        static {
            LinkedHashSet<ValidationType> cts = new LinkedHashSet<ValidationType>(ValidationType.values().length - 1);
            for (ValidationType v : ValidationType.values()) {
                if (v == ALL) continue;
                cts.add(v);
            }
            CONCRETE_TYPES = Collections.unmodifiableSet(cts);
        }
    }
}

