/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.MultiVariantWalker;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.vqsr.TruthSensitivityTranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantDataManager;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantRecalibrationUtils;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantRecalibratorArgumentCollection;
import org.broadinstitute.hellbender.utils.variant.GATKVCFConstants;
import picard.cmdline.programgroups.VariantFilteringProgramGroup;

@CommandLineProgramProperties(summary="Apply a score cutoff to filter variants based on a recalibration table", oneLineSummary=" Apply a score cutoff to filter variants based on a recalibration table", programGroup=VariantFilteringProgramGroup.class)
@DocumentedFeature
public class ApplyVQSR
extends MultiVariantWalker {
    protected static final String LOW_VQSLOD_FILTER_NAME = "LOW_VQSLOD";
    private final double DEFAULT_VQSLOD_CUTOFF = 0.0;
    private boolean foundSNPTranches = false;
    private boolean foundINDELTranches = false;
    @Argument(fullName="recal-file", doc="The input recal file used by ApplyVQSR", optional=false)
    private FeatureInput<VariantContext> recal;
    @Argument(fullName="tranches-file", doc="The input tranches file describing where to cut the data", optional=true)
    private GATKPath TRANCHES_FILE;
    @Argument(fullName="output", shortName="O", doc="The output filtered and recalibrated VCF file in which each variant is annotated with its VQSLOD value", optional=false)
    private GATKPath output;
    @Argument(fullName="truth-sensitivity-filter-level", shortName="ts-filter-level", doc="The truth sensitivity level at which to start filtering", optional=true)
    private Double TS_FILTER_LEVEL = null;
    @Argument(fullName="use-allele-specific-annotations", shortName="AS", doc="If specified, the tool will attempt to apply a filter to each allele based on the input tranches and allele-specific .recal file.", optional=true)
    private boolean useASannotations = false;
    @Advanced
    @Argument(fullName="lod-score-cutoff", doc="The VQSLOD score below which to start filtering", optional=true)
    protected Double VQSLOD_CUTOFF = null;
    @Argument(fullName="ignore-filter", doc="If specified, the recalibration will be applied to variants marked as filtered by the specified filter name in the input VCF file", optional=true)
    private List<String> IGNORE_INPUT_FILTERS = new ArrayList<String>();
    @Argument(fullName="ignore-all-filters", doc="If specified, the variant recalibrator will ignore all input filters. Useful to rerun the VQSR from a filtered output file.", optional=true)
    private boolean IGNORE_ALL_FILTERS = false;
    @Argument(fullName="exclude-filtered", doc="Don't output filtered loci after applying the recalibration", optional=true)
    private boolean EXCLUDE_FILTERED = false;
    @Argument(fullName="mode", shortName="mode", doc="Recalibration mode to employ: 1.) SNP for recalibrating only SNPs (emitting indels untouched in the output VCF); 2.) INDEL for indels; and 3.) BOTH for recalibrating both SNPs and indels simultaneously.", optional=true)
    private VariantRecalibratorArgumentCollection.Mode MODE = VariantRecalibratorArgumentCollection.Mode.SNP;
    private VariantContextWriter vcfWriter;
    private final List<TruthSensitivityTranche> tranches = new ArrayList<TruthSensitivityTranche>();
    private final Set<String> ignoreInputFilterSet = new TreeSet<String>();
    private static final String listPrintSeparator = ",";
    private static final String trancheFilterString = "VQSRTranche";
    private static final String arrayParseRegex = "[\\[\\]\\s]";
    private static final String emptyStringValue = "NA";
    private static final String emptyFloatValue = "NaN";

    @Override
    public void onTraversalStart() {
        if (this.TS_FILTER_LEVEL != null) {
            try {
                for (TruthSensitivityTranche t : TruthSensitivityTranche.readTranches(this.TRANCHES_FILE)) {
                    if (t.targetTruthSensitivity >= this.TS_FILTER_LEVEL) {
                        this.tranches.add(t);
                    }
                    this.logger.info(String.format("Read tranche " + t, new Object[0]));
                }
            }
            catch (IOException e) {
                throw new UserException.CouldNotReadInputFile(this.TRANCHES_FILE, "Can't read tranches file", (Throwable)e);
            }
            Collections.reverse(this.tranches);
        }
        if (this.IGNORE_INPUT_FILTERS != null) {
            this.ignoreInputFilterSet.addAll(this.IGNORE_INPUT_FILTERS);
        }
        VCFHeader inputHeader = this.getHeaderForVariants();
        Set inputHeaders = inputHeader.getMetaDataInSortedOrder();
        HashSet<VCFHeaderLine> hInfo = new HashSet<VCFHeaderLine>(inputHeaders);
        VariantRecalibrationUtils.addVQSRStandardHeaderLines(hInfo);
        if (this.useASannotations) {
            VariantRecalibrationUtils.addAlleleSpecificVQSRHeaderLines(hInfo);
        }
        this.checkForPreviousApplyRecalRun(Collections.unmodifiableSet(inputHeaders));
        TreeSet samples = new TreeSet();
        samples.addAll(inputHeader.getGenotypeSamples());
        if (this.TS_FILTER_LEVEL != null) {
            if (this.VQSLOD_CUTOFF != null) {
                throw new UserException("Arguments --truth-sensitivity-filter-level and --lod-score-cutoff are mutually exclusive. Please only specify one option.");
            }
            if (this.tranches.size() >= 2) {
                for (int iii = 0; iii < this.tranches.size() - 1; ++iii) {
                    TruthSensitivityTranche t = this.tranches.get(iii);
                    hInfo.add((VCFHeaderLine)new VCFFilterHeaderLine(t.name, String.format("Truth sensitivity tranche level for " + t.model.toString() + " model at VQS Lod: " + t.minVQSLod + " <= x < " + this.tranches.get((int)(iii + 1)).minVQSLod, new Object[0])));
                }
            }
            if (this.tranches.size() < 1) {
                throw new UserException("No tranches were found in the file or were above the truth sensitivity filter level " + this.TS_FILTER_LEVEL);
            }
            hInfo.add((VCFHeaderLine)new VCFFilterHeaderLine(this.tranches.get((int)0).name + "+", String.format("Truth sensitivity tranche level for " + this.tranches.get((int)0).model.toString() + " model at VQS Lod < " + this.tranches.get((int)0).minVQSLod, new Object[0])));
            this.logger.info("Keeping all variants in tranche " + this.tranches.get(this.tranches.size() - 1));
        } else {
            if (this.VQSLOD_CUTOFF == null) {
                this.VQSLOD_CUTOFF = 0.0;
            }
            hInfo.add((VCFHeaderLine)new VCFFilterHeaderLine(LOW_VQSLOD_FILTER_NAME, "VQSLOD < " + this.VQSLOD_CUTOFF));
            this.logger.info("Keeping all variants with VQSLOD >= " + this.VQSLOD_CUTOFF);
        }
        hInfo.addAll(this.getDefaultToolVCFHeaderLines());
        VCFHeader vcfHeader = new VCFHeader(hInfo, samples);
        this.vcfWriter = this.createVCFWriter(this.output);
        this.vcfWriter.writeHeader(vcfHeader);
    }

    private boolean trancheIntervalIsValid(String sensitivityLimits) {
        String[] vals = sensitivityLimits.split("to");
        if (vals.length != 2) {
            return false;
        }
        try {
            double lowerLimit = Double.parseDouble(vals[0]);
            double d = Double.parseDouble(vals[1].replace("+", ""));
        }
        catch (NumberFormatException e) {
            throw new UserException("Poorly formatted tranche filter name does not contain two sensitivity interval end points.");
        }
        return true;
    }

    private void checkForPreviousApplyRecalRun(Set<VCFHeaderLine> inputHeaders) {
        for (VCFHeaderLine header : inputHeaders) {
            String sensitivityLimits;
            String filterName;
            if (!(header instanceof VCFFilterHeaderLine) || (filterName = ((VCFFilterHeaderLine)header).getID()).length() < 12 || !filterName.substring(0, 11).equalsIgnoreCase(trancheFilterString)) continue;
            if (filterName.charAt(11) == 'S') {
                sensitivityLimits = filterName.substring(14);
                if (!this.trancheIntervalIsValid(sensitivityLimits)) continue;
                this.foundSNPTranches = true;
                continue;
            }
            if (filterName.charAt(11) != 'I' || !this.trancheIntervalIsValid(sensitivityLimits = filterName.substring(16))) continue;
            this.foundINDELTranches = true;
        }
    }

    @Override
    public void apply(VariantContext vc, ReadsContext readsContext, ReferenceContext ref, FeatureContext featureContext) {
        boolean variantIsNotFiltered;
        List<VariantContext> recals = featureContext.getValues(this.recal, vc.getStart());
        boolean evaluateThisVariant = this.useASannotations || VariantDataManager.checkVariationClass(vc, this.MODE);
        boolean bl = variantIsNotFiltered = this.IGNORE_ALL_FILTERS || vc.isNotFiltered() || !this.ignoreInputFilterSet.isEmpty() && this.ignoreInputFilterSet.containsAll(vc.getFilters());
        if (evaluateThisVariant && variantIsNotFiltered) {
            VariantContextBuilder builder = new VariantContextBuilder(vc);
            String filterString = !this.useASannotations ? this.doSiteSpecificFiltering(vc, recals, builder) : this.doAlleleSpecificFiltering(vc, recals, builder);
            if (filterString.equals("PASS")) {
                builder.passFilters();
            } else if (filterString.equals(".")) {
                builder.unfiltered();
            } else {
                builder.filters(new String[]{filterString});
            }
            VariantContext outputVC = builder.make();
            if (!this.EXCLUDE_FILTERED || outputVC.isNotFiltered()) {
                this.vcfWriter.add(outputVC);
            }
        } else {
            this.vcfWriter.add(vc);
        }
    }

    public double parseFilterLowerLimit(String trancheFilter) {
        Pattern pattern = Pattern.compile("VQSRTranche\\S+(\\d+\\.\\d+)to(\\d+\\.\\d+)");
        Matcher m = pattern.matcher(trancheFilter);
        return m.find() ? Double.parseDouble(m.group(1)) : -1.0;
    }

    protected String generateFilterStringFromAlleles(VariantContext vc, double bestLod) {
        boolean onlyOneModeNeeded;
        String filterString = ".";
        boolean bothModesWereRun = this.MODE == VariantRecalibratorArgumentCollection.Mode.SNP && this.foundINDELTranches || this.MODE == VariantRecalibratorArgumentCollection.Mode.INDEL && this.foundSNPTranches;
        boolean bl = onlyOneModeNeeded = !vc.isMixed() && VariantDataManager.checkVariationClass(vc, this.MODE);
        if (!bothModesWereRun && !onlyOneModeNeeded) {
            return ".";
        }
        String prevFilterStatus = vc.getAttributeAsString("AS_FilterStatus", null);
        if (prevFilterStatus != null && !prevFilterStatus.equals(".")) {
            String prevAllelesFilterStatusString = vc.getAttributeAsString("AS_FilterStatus", null);
            String[] prevAllelesFilterStatusList = prevAllelesFilterStatusString.split(listPrintSeparator);
            String mostLenientFilterName = this.generateFilterString(bestLod);
            if (mostLenientFilterName.equals("PASS")) {
                filterString = mostLenientFilterName;
            } else {
                double mostLenientSensitivityLowerLimit = this.parseFilterLowerLimit(mostLenientFilterName);
                for (int i = 0; i < prevAllelesFilterStatusList.length; ++i) {
                    String alleleFilterString = prevAllelesFilterStatusList[i].replaceAll(arrayParseRegex, "").trim();
                    if (alleleFilterString.equals("PASS")) {
                        mostLenientFilterName = alleleFilterString;
                        break;
                    }
                    double alleleLowerLimit = this.parseFilterLowerLimit(alleleFilterString);
                    if (alleleLowerLimit == -1.0 || !(alleleLowerLimit < mostLenientSensitivityLowerLimit)) continue;
                    mostLenientSensitivityLowerLimit = alleleLowerLimit;
                    mostLenientFilterName = alleleFilterString;
                }
                filterString = mostLenientFilterName;
            }
        } else {
            filterString = this.generateFilterString(bestLod);
        }
        return filterString;
    }

    protected String generateFilterString(double lod) {
        String filterString = null;
        if (this.TS_FILTER_LEVEL != null) {
            for (int i = this.tranches.size() - 1; i >= 0; --i) {
                TruthSensitivityTranche tranche = this.tranches.get(i);
                if (!(lod >= tranche.minVQSLod)) continue;
                if (i == this.tranches.size() - 1) {
                    filterString = "PASS";
                    break;
                }
                filterString = tranche.name;
                break;
            }
            if (filterString == null) {
                filterString = this.tranches.get((int)0).name + "+";
            }
        } else {
            filterString = lod < this.VQSLOD_CUTOFF ? LOW_VQSLOD_FILTER_NAME : "PASS";
        }
        return filterString;
    }

    private VariantContext getMatchingRecalVC(VariantContext target, List<VariantContext> recalVCs, Allele allele) {
        for (VariantContext recalVC : recalVCs) {
            if (target.getEnd() != recalVC.getEnd()) continue;
            if (!this.useASannotations) {
                return recalVC;
            }
            if (!allele.equals((Object)recalVC.getAlternateAllele(0))) continue;
            return recalVC;
        }
        return null;
    }

    private void updateAnnotationsWithoutRecalibrating(int altIndex, String[] prevCulpritList, String[] prevLodList, String[] prevASfiltersList, List<String> culpritString, List<String> lodString, List<String> AS_filterString) {
        if (this.foundINDELTranches || this.foundSNPTranches) {
            if (altIndex < prevCulpritList.length) {
                culpritString.add(prevCulpritList[altIndex].replaceAll(arrayParseRegex, "").trim());
                lodString.add(prevLodList[altIndex].replaceAll(arrayParseRegex, "").trim());
                AS_filterString.add(prevASfiltersList[altIndex].replaceAll(arrayParseRegex, "").trim());
            }
        } else {
            culpritString.add(emptyStringValue);
            lodString.add(emptyFloatValue);
            AS_filterString.add(emptyStringValue);
        }
    }

    private String doAlleleSpecificFiltering(VariantContext vc, List<VariantContext> recals, VariantContextBuilder builder) {
        double bestLod = -20000.0;
        ArrayList<String> culpritStrings = new ArrayList<String>();
        ArrayList<String> lodStrings = new ArrayList<String>();
        ArrayList<String> AS_filterStrings = new ArrayList<String>();
        String[] prevCulpritList = null;
        String[] prevLodList = null;
        String[] prevASfiltersList = null;
        if (this.foundINDELTranches || this.foundSNPTranches) {
            String prevCulprits = vc.getAttributeAsString("AS_culprit", "");
            prevCulpritList = prevCulprits.isEmpty() ? new String[]{} : prevCulprits.split(listPrintSeparator);
            String prevLodString = vc.getAttributeAsString("AS_VQSLOD", "");
            prevLodList = prevLodString.isEmpty() ? new String[]{} : prevLodString.split(listPrintSeparator);
            String prevASfilters = vc.getAttributeAsString("AS_FilterStatus", "");
            prevASfiltersList = prevASfilters.isEmpty() ? new String[]{} : prevASfilters.split(listPrintSeparator);
        }
        for (int altIndex = 0; altIndex < vc.getNAlleles() - 1; ++altIndex) {
            Allele allele = vc.getAlternateAllele(altIndex);
            if (!VariantDataManager.checkVariationClass(vc, allele, this.MODE)) {
                this.updateAnnotationsWithoutRecalibrating(altIndex, prevCulpritList, prevLodList, prevASfiltersList, culpritStrings, lodStrings, AS_filterStrings);
                continue;
            }
            String alleleLodString = emptyFloatValue;
            String alleleFilterString = emptyStringValue;
            String alleleCulpritString = emptyStringValue;
            if (!GATKVCFConstants.isSpanningDeletion(allele)) {
                VariantContext recalDatum = this.getMatchingRecalVC(vc, recals, allele);
                if (recalDatum == null) {
                    throw new UserException("Encountered input allele which isn't found in the input recal file. Please make sure VariantRecalibrator and ApplyVQSR were run on the same set of input variants with flag -AS. First seen at: " + vc);
                }
                double lod = recalDatum.getAttributeAsDouble("VQSLOD", -20000.0);
                if (lod > bestLod) {
                    bestLod = lod;
                }
                alleleLodString = String.format("%.4f", lod);
                alleleFilterString = this.generateFilterString(lod);
                alleleCulpritString = recalDatum.getAttributeAsString("culprit", ".");
                if (recalDatum != null) {
                    if (recalDatum.hasAttribute("POSITIVE_TRAIN_SITE")) {
                        builder.attribute("POSITIVE_TRAIN_SITE", (Object)true);
                    }
                    if (recalDatum.hasAttribute("NEGATIVE_TRAIN_SITE")) {
                        builder.attribute("NEGATIVE_TRAIN_SITE", (Object)true);
                    }
                }
            }
            lodStrings.add(alleleLodString);
            AS_filterStrings.add(alleleFilterString);
            culpritStrings.add(alleleCulpritString);
        }
        if (!AS_filterStrings.isEmpty()) {
            builder.attribute("AS_FilterStatus", (Object)AnnotationUtils.encodeStringList(AS_filterStrings));
        }
        if (!lodStrings.isEmpty()) {
            builder.attribute("AS_VQSLOD", (Object)AnnotationUtils.encodeStringList(lodStrings));
        }
        if (!culpritStrings.isEmpty()) {
            builder.attribute("AS_culprit", (Object)AnnotationUtils.encodeStringList(culpritStrings));
        }
        return this.generateFilterStringFromAlleles(vc, bestLod);
    }

    private String doSiteSpecificFiltering(VariantContext vc, List<VariantContext> recals, VariantContextBuilder builder) {
        double lod;
        VariantContext recalDatum = this.getMatchingRecalVC(vc, recals, null);
        if (recalDatum == null) {
            throw new UserException("Encountered input variant which isn't found in the input recal file. Please make sure VariantRecalibrator and ApplyVQSR were run on the same set of input variants. First seen at: " + vc);
        }
        String lodString = recalDatum.getAttributeAsString("VQSLOD", null);
        if (lodString == null) {
            throw new UserException("Encountered a malformed record in the input recal file. There is no lod for the record at: " + vc);
        }
        try {
            lod = Double.valueOf(lodString);
        }
        catch (NumberFormatException e) {
            throw new UserException("Encountered a malformed record in the input recal file. The lod is unreadable for the record at: " + vc);
        }
        builder.attribute("VQSLOD", (Object)lod);
        builder.attribute("culprit", recalDatum.getAttribute("culprit"));
        if (recalDatum != null) {
            if (recalDatum.hasAttribute("POSITIVE_TRAIN_SITE")) {
                builder.attribute("POSITIVE_TRAIN_SITE", (Object)true);
            }
            if (recalDatum.hasAttribute("NEGATIVE_TRAIN_SITE")) {
                builder.attribute("NEGATIVE_TRAIN_SITE", (Object)true);
            }
        }
        return this.generateFilterString(lod);
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }
}

