/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import java.util.ArrayList;
import java.util.Arrays;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.vqsr.TensorType;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.python.PythonScriptExecutor;
import picard.cmdline.programgroups.VariantFilteringProgramGroup;

@CommandLineProgramProperties(summary="Write variant tensors for training a CNN to filter variants", oneLineSummary="Write variant tensors for training a CNN to filter variants", programGroup=VariantFilteringProgramGroup.class)
@DocumentedFeature
@ExperimentalFeature
public class CNNVariantWriteTensors
extends CommandLineProgram {
    @Argument(fullName="reference", shortName="R", doc="Reference fasta file.")
    private String reference;
    @Argument(fullName="variant", shortName="V", doc="Input VCF file")
    private String inputVcf;
    @Argument(fullName="output-tensor-dir", shortName="output-tensor-dir", doc="Directory of training tensors. Subdivided into train, valid and test sets.")
    private String outputTensorsDir;
    @Argument(fullName="truth-vcf", shortName="truth-vcf", doc="Validated VCF file.")
    private String truthVcf;
    @Argument(fullName="truth-bed", shortName="truth-bed", doc="Confident region of the validated VCF file.")
    private String truthBed;
    @Argument(fullName="bam-file", shortName="bam-file", doc="BAM or BAMout file to use for read data when generating 2D tensors.", optional=true)
    private String bamFile = "";
    @Argument(fullName="tensor-type", shortName="tensor-type", doc="Name of the tensors to generate.")
    private TensorType tensorType = TensorType.reference;
    @Argument(fullName="downsample-snps", shortName="downsample-snps", doc="Fraction of SNPs to write tensors for.", optional=true)
    private float downsampleSnps = 0.05f;
    @Argument(fullName="downsample-indels", shortName="downsample-indels", doc="Fraction of INDELs to write tensors for.", optional=true)
    private float downsampleIndels = 0.5f;
    @Advanced
    @Argument(fullName="channels-last", shortName="channels-last", doc="Store the channels in the last axis of tensors, tensorflow->true, theano->false", optional=true)
    private boolean channelsLast = true;
    @Advanced
    @Argument(fullName="annotation-set", shortName="annotation-set", doc="Which set of annotations to use.", optional=true)
    private String annotationSet = "best_practices";
    @Argument(fullName="max-tensors", shortName="max-tensors", doc="Maximum number of tensors to write.", optional=true, minValue=0.0)
    private int maxTensors = 1000000;
    final PythonScriptExecutor pythonExecutor = new PythonScriptExecutor(true);

    @Override
    protected void onStartup() {
        PythonScriptExecutor.checkPythonEnvironmentForPackage("vqsr_cnn");
    }

    @Override
    protected Object doWork() {
        Resource pythonScriptResource = new Resource("training.py", CNNVariantWriteTensors.class);
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList("--reference_fasta", this.reference, "--input_vcf", this.inputVcf, "--bam_file", this.bamFile, "--train_vcf", this.truthVcf, "--bed_file", this.truthBed, "--tensor_name", this.tensorType.name(), "--annotation_set", this.annotationSet, "--samples", Integer.toString(this.maxTensors), "--downsample_snps", Float.toString(this.downsampleSnps), "--downsample_indels", Float.toString(this.downsampleIndels), "--data_dir", this.outputTensorsDir));
        if (this.channelsLast) {
            arguments.add("--channels_last");
        } else {
            arguments.add("--channels_first");
        }
        if (this.tensorType == TensorType.reference) {
            arguments.addAll(Arrays.asList("--mode", "write_reference_and_annotation_tensors"));
        } else if (this.tensorType == TensorType.read_tensor) {
            arguments.addAll(Arrays.asList("--mode", "write_read_and_annotation_tensors"));
        } else {
            throw new GATKException("Unknown tensor mapping mode:" + this.tensorType.name());
        }
        this.logger.info("Args are:" + Arrays.toString(arguments.toArray()));
        boolean pythonReturnCode = this.pythonExecutor.executeScript(pythonScriptResource, null, arguments);
        return pythonReturnCode;
    }
}

