/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import htsjdk.samtools.util.IOUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowInput;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.vqsr.Tranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.TruthSensitivityTranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VQSLODTranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantRecalibratorArgumentCollection;
import picard.cmdline.programgroups.OtherProgramGroup;

@CommandLineProgramProperties(summary="Gathers scattered VQSLOD tranches into a single file. For use when running VariantRecalibrator on scattered input using the -scatterTranches mode.", oneLineSummary="Gathers scattered VQSLOD tranches into a single file", programGroup=OtherProgramGroup.class)
@BetaFeature
@DocumentedFeature
@WorkflowProperties
public class GatherTranches
extends CommandLineProgram {
    @Argument(fullName="input", shortName="I", doc="List of scattered tranches files")
    @WorkflowInput
    public final List<GATKPath> inputReports = new ArrayList<GATKPath>();
    @Argument(fullName="truth-sensitivity-tranche", shortName="tranche", doc="The levels of truth sensitivity at which to slice the data. (in percent, that is 1.0 for 1 percent)", optional=true)
    private List<Double> TS_TRANCHES = new ArrayList<Double>(Arrays.asList(100.0, 99.9, 99.0, 90.0));
    @Argument(fullName="mode", shortName="mode", doc="Recalibration mode to employ")
    public VariantRecalibratorArgumentCollection.Mode MODE;
    @Argument(fullName="output", shortName="O", doc="File to output the gathered tranches file to")
    @WorkflowOutput
    public GATKPath outputReport;

    @Override
    protected Object doWork() {
        this.inputReports.stream().map(GATKPath::toPath).forEach(IOUtil::assertFileIsReadable);
        try (PrintStream tranchesStream = new PrintStream(this.outputReport.getOutputStream());){
            TreeMap<Double, List<VQSLODTranche>> scatteredTranches = new TreeMap<Double, List<VQSLODTranche>>();
            for (GATKPath trancheFile : this.inputReports) {
                try {
                    for (VQSLODTranche currentTranche : VQSLODTranche.readTranches(trancheFile)) {
                        if (scatteredTranches.containsKey(currentTranche.minVQSLod)) {
                            scatteredTranches.get(currentTranche.minVQSLod).add(currentTranche);
                            continue;
                        }
                        scatteredTranches.put(currentTranche.minVQSLod, new ArrayList<VQSLODTranche>(Arrays.asList(currentTranche)));
                    }
                }
                catch (IOException e) {
                    throw new UserException.CouldNotReadInputFile(trancheFile, "Error reading tranch input", (Throwable)e);
                }
            }
            tranchesStream.print(TruthSensitivityTranche.printHeader());
            tranchesStream.print(Tranche.tranchesString(VQSLODTranche.mergeAndConvertTranches(scatteredTranches, this.TS_TRANCHES, this.MODE)));
            Integer n = 0;
            return n;
        }
    }
}

