/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import Jama.Matrix;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.special.Gamma;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantDatum;
import org.broadinstitute.hellbender.utils.MathUtils;

class MultivariateGaussian {
    public double pMixtureLog10;
    public double sumProb;
    public final double[] mu;
    public final Matrix sigma;
    public double hyperParameter_a;
    public double hyperParameter_b;
    public double hyperParameter_lambda;
    private double cachedDenomLog10;
    private Matrix cachedSigmaInverse;
    private final double[] pVarInGaussian;
    int pVarInGaussianIndex;
    private static final double EPSILON = 1.0E-200;

    public MultivariateGaussian(int numVariants, int numAnnotations) {
        this.mu = new double[numAnnotations];
        this.sigma = new Matrix(numAnnotations, numAnnotations);
        this.pVarInGaussian = new double[numVariants];
        this.pVarInGaussianIndex = 0;
    }

    public void zeroOutMu() {
        Arrays.fill(this.mu, 0.0);
    }

    public void zeroOutSigma() {
        double[][] zeroSigma;
        for (double[] row : zeroSigma = new double[this.mu.length][this.mu.length]) {
            Arrays.fill(row, 0.0);
        }
        Matrix tmp = new Matrix(zeroSigma);
        this.sigma.setMatrix(0, this.mu.length - 1, 0, this.mu.length - 1, tmp);
    }

    public void initializeRandomMu(Random rand) {
        for (int jjj = 0; jjj < this.mu.length; ++jjj) {
            this.mu[jjj] = -4.0 + 8.0 * rand.nextDouble();
        }
    }

    public void initializeRandomSigma(Random rand) {
        double[][] randSigma = new double[this.mu.length][this.mu.length];
        for (int iii = 0; iii < this.mu.length; ++iii) {
            for (int jjj = iii; jjj < this.mu.length; ++jjj) {
                randSigma[jjj][iii] = 0.55 + 1.25 * rand.nextDouble();
                if (rand.nextBoolean()) {
                    double[] dArray = randSigma[jjj];
                    int n = iii;
                    dArray[n] = dArray[n] * -1.0;
                }
                if (iii == jjj) continue;
                randSigma[iii][jjj] = 0.0;
            }
        }
        Matrix tmp = new Matrix(randSigma);
        tmp = tmp.times(tmp.transpose());
        this.sigma.setMatrix(0, this.mu.length - 1, 0, this.mu.length - 1, tmp);
    }

    public double calculateDistanceFromMeanSquared(VariantDatum datum) {
        return MathUtils.distanceSquared(datum.annotations, this.mu);
    }

    public void incrementMu(VariantDatum datum) {
        this.incrementMu(datum, 1.0);
    }

    public void incrementMu(VariantDatum datum, double prob) {
        for (int jjj = 0; jjj < this.mu.length; ++jjj) {
            int n = jjj;
            this.mu[n] = this.mu[n] + prob * datum.annotations[jjj];
        }
    }

    public void divideEqualsMu(double x) {
        int jjj = 0;
        while (jjj < this.mu.length) {
            int n = jjj++;
            this.mu[n] = this.mu[n] / x;
        }
    }

    private void precomputeInverse() {
        try {
            this.cachedSigmaInverse = this.sigma.inverse();
        }
        catch (RuntimeException e) {
            throw new UserException("Error during clustering. Most likely there are too few variants used during Gaussian mixture modeling. Please consider raising the number of variants used to train the negative model (via --percentBadVariants 0.05, for example) or lowering the maximum number of Gaussians to use in the model (via --maxGaussians 4, for example).", e);
        }
    }

    public void precomputeDenominatorForEvaluation() {
        if (this.pMixtureLog10 == Double.NEGATIVE_INFINITY) {
            return;
        }
        this.precomputeInverse();
        this.cachedDenomLog10 = Math.log10(Math.pow(Math.PI * 2, -1.0 * (double)this.mu.length / 2.0)) + Math.log10(Math.pow(this.sigma.det(), -0.5));
        if (Double.isNaN(this.cachedDenomLog10) || this.sigma.det() < 1.0E-200) {
            throw new GATKException("Denominator for gaussian evaluation cannot be computed. Covariance determinant is " + this.sigma.det() + ". One or more annotations (usually MQ) may have insufficient variance.");
        }
    }

    public void precomputeDenominatorForVariationalBayes(double sumHyperParameterLambda) {
        this.precomputeInverse();
        this.cachedSigmaInverse.timesEquals(this.hyperParameter_a);
        double sum = 0.0;
        for (int jjj = 1; jjj <= this.mu.length; ++jjj) {
            sum += Gamma.digamma((double)((this.hyperParameter_a + 1.0 - (double)jjj) / 2.0));
        }
        sum -= Math.log(this.sigma.det());
        double lambda = 0.5 * (sum += Math.log(2.0) * (double)this.mu.length);
        double pi = Gamma.digamma((double)this.hyperParameter_lambda) - Gamma.digamma((double)sumHyperParameterLambda);
        double beta = -1.0 * (double)this.mu.length / (2.0 * this.hyperParameter_b);
        this.cachedDenomLog10 = pi / Math.log(10.0) + lambda / Math.log(10.0) + beta / Math.log(10.0);
    }

    public double evaluateDatumLog10(VariantDatum datum) {
        int iii;
        if (this.pMixtureLog10 == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double sumKernel = 0.0;
        double[] crossProdTmp = new double[this.mu.length];
        Arrays.fill(crossProdTmp, 0.0);
        for (iii = 0; iii < this.mu.length; ++iii) {
            for (int jjj = 0; jjj < this.mu.length; ++jjj) {
                int n = iii;
                crossProdTmp[n] = crossProdTmp[n] + (datum.annotations[jjj] - this.mu[jjj]) * this.cachedSigmaInverse.get(jjj, iii);
            }
        }
        for (iii = 0; iii < this.mu.length; ++iii) {
            sumKernel += crossProdTmp[iii] * (datum.annotations[iii] - this.mu[iii]);
        }
        return -0.5 * sumKernel / Math.log(10.0) + this.cachedDenomLog10;
    }

    public void assignPVarInGaussian(double pVar) {
        this.pVarInGaussian[this.pVarInGaussianIndex++] = pVar;
    }

    public void resetPVarInGaussian() {
        Arrays.fill(this.pVarInGaussian, 0.0);
        this.pVarInGaussianIndex = 0;
    }

    public void maximizeGaussian(List<VariantDatum> data, double[] empiricalMu, Matrix empiricalSigma, double SHRINKAGE, double DIRICHLET_PARAMETER, double DEGREES_OF_FREEDOM) {
        this.sumProb = 1.0E-10;
        Matrix wishart = new Matrix(this.mu.length, this.mu.length);
        this.zeroOutMu();
        this.zeroOutSigma();
        int datumIndex = 0;
        for (VariantDatum datum : data) {
            double prob = this.pVarInGaussian[datumIndex++];
            this.sumProb += prob;
            this.incrementMu(datum, prob);
        }
        this.divideEqualsMu(this.sumProb);
        double shrinkageFactor = SHRINKAGE * this.sumProb / (SHRINKAGE + this.sumProb);
        for (int iii = 0; iii < this.mu.length; ++iii) {
            double deltaMu = shrinkageFactor * (this.mu[iii] - empiricalMu[iii]);
            for (int jjj = 0; jjj < this.mu.length; ++jjj) {
                wishart.set(iii, jjj, deltaMu * (this.mu[jjj] - empiricalMu[jjj]));
            }
        }
        datumIndex = 0;
        Matrix pVarSigma = new Matrix(this.mu.length, this.mu.length);
        for (VariantDatum datum : data) {
            double prob = this.pVarInGaussian[datumIndex++];
            for (int iii = 0; iii < this.mu.length; ++iii) {
                double deltaMu = prob * (datum.annotations[iii] - this.mu[iii]);
                for (int jjj = 0; jjj < this.mu.length; ++jjj) {
                    pVarSigma.set(iii, jjj, deltaMu * (datum.annotations[jjj] - this.mu[jjj]));
                }
            }
            this.sigma.plusEquals(pVarSigma);
        }
        this.sigma.plusEquals(empiricalSigma);
        this.sigma.plusEquals(wishart);
        for (int iii = 0; iii < this.mu.length; ++iii) {
            this.mu[iii] = (this.sumProb * this.mu[iii] + SHRINKAGE * empiricalMu[iii]) / (this.sumProb + SHRINKAGE);
        }
        this.hyperParameter_a = this.sumProb + DEGREES_OF_FREEDOM;
        this.hyperParameter_b = this.sumProb + SHRINKAGE;
        this.hyperParameter_lambda = this.sumProb + DIRICHLET_PARAMETER;
        this.resetPVarInGaussian();
    }

    public void evaluateFinalModelParameters(List<VariantDatum> data) {
        this.sumProb = 0.0;
        this.zeroOutMu();
        this.zeroOutSigma();
        int datumIndex = 0;
        for (VariantDatum datum : data) {
            double prob = this.pVarInGaussian[datumIndex++];
            this.sumProb += prob;
            this.incrementMu(datum, prob);
        }
        this.divideEqualsMu(this.sumProb);
        datumIndex = 0;
        Matrix pVarSigma = new Matrix(this.mu.length, this.mu.length);
        for (VariantDatum datum : data) {
            double prob = this.pVarInGaussian[datumIndex++];
            for (int iii = 0; iii < this.mu.length; ++iii) {
                for (int jjj = 0; jjj < this.mu.length; ++jjj) {
                    pVarSigma.set(iii, jjj, prob * (datum.annotations[iii] - this.mu[iii]) * (datum.annotations[jjj] - this.mu[jjj]));
                }
            }
            this.sigma.plusEquals(pVarSigma);
        }
        this.sigma.timesEquals(1.0 / this.sumProb);
        this.resetPVarInGaussian();
    }
}

