/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import htsjdk.variant.variantcontext.VariantContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;

public class TrainingSet {
    public FeatureInput<VariantContext> variantSource;
    public boolean isKnown = false;
    public boolean isTraining = false;
    public boolean isAntiTraining = false;
    public boolean isTruth = false;
    public boolean isConsensus = false;
    public double prior = 0.0;
    protected final Logger logger = LogManager.getLogger(TrainingSet.class);

    public TrainingSet(FeatureInput<VariantContext> variantContextFeatureSource) {
        Utils.nonNull(variantContextFeatureSource);
        this.variantSource = variantContextFeatureSource;
        String name = variantContextFeatureSource.getName();
        this.isKnown = this.getBooleanAttribute(this.variantSource, "known");
        this.isTraining = this.getBooleanAttribute(this.variantSource, "training");
        this.isAntiTraining = this.getBooleanAttribute(this.variantSource, "bad");
        this.isTruth = this.getBooleanAttribute(this.variantSource, "truth");
        this.isConsensus = this.getBooleanAttribute(this.variantSource, "consensus");
        this.prior = this.getDoubleAttributeOrElse(this.variantSource, "prior", this.prior);
        if (!this.isConsensus && !this.isAntiTraining) {
            this.logger.info(String.format("Found %s track: \tKnown = %s \tTraining = %s \tTruth = %s \tPrior = Q%.1f", name, this.isKnown, this.isTraining, this.isTruth, this.prior));
        } else if (this.isConsensus) {
            this.logger.info(String.format("Found consensus track: %s", name));
        } else {
            this.logger.info(String.format("Found bad sites training track: %s", name));
        }
    }

    private boolean getBooleanAttribute(FeatureInput<VariantContext> variantSource, String key) {
        String attributeValue = variantSource.getAttribute(key);
        return attributeValue != null && attributeValue.equals("true");
    }

    private double getDoubleAttributeOrElse(FeatureInput<VariantContext> variantSource, String key, double defaultValue) {
        String attributeValue = variantSource.getAttribute(key);
        try {
            return attributeValue == null ? defaultValue : Double.valueOf(attributeValue);
        }
        catch (NumberFormatException e) {
            throw new UserException.MalformedFile("Malformed floating point value" + key);
        }
    }
}

