/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.vqsr.TruthSensitivityTranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantDatum;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantRecalibratorArgumentCollection;

public class Tranche {
    protected static final String DEFAULT_TRANCHE_NAME = "anonymous";
    protected static final String COMMENT_STRING = "#";
    protected static final String VALUE_SEPARATOR = ",";
    protected static final int EXPECTED_COLUMN_COUNT = 11;
    protected final int accessibleTruthSites;
    protected final int callsAtTruthSites;
    final double minVQSLod;
    final double knownTiTv;
    final double novelTiTv;
    final int numKnown;
    final int numNovel;
    final VariantRecalibratorArgumentCollection.Mode model;
    final String name;

    public Tranche(String name, double knownTiTv, int numNovel, double minVQSLod, VariantRecalibratorArgumentCollection.Mode model, double novelTiTv, int accessibleTruthSites, int numKnown, int callsAtTruthSites) {
        if (numKnown < 0 || numNovel < 0) {
            throw new GATKException("Invalid tranche - no. variants is < 0 : known " + numKnown + " novel " + numNovel);
        }
        if (name == null) {
            throw new GATKException("BUG -- name cannot be null");
        }
        this.name = name;
        this.knownTiTv = knownTiTv;
        this.numNovel = numNovel;
        this.minVQSLod = minVQSLod;
        this.model = model;
        this.novelTiTv = novelTiTv;
        this.accessibleTruthSites = accessibleTruthSites;
        this.numKnown = numKnown;
        this.callsAtTruthSites = callsAtTruthSites;
    }

    /*
     * Exception decompiling
     */
    public static String tranchesString(List<? extends Tranche> tranches) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Double getTrancheIndex() {
        return this.getTruthSensitivity();
    }

    public <T extends Tranche> String getTrancheString(T prev) {
        return String.format("%.2f,%d,%d,%.4f,%.4f,%.4f,VQSRTranche%s%.2fto%.2f,%s,%d,%d,%.4f%n", this.getTrancheIndex(), this.numKnown, this.numNovel, this.knownTiTv, this.novelTiTv, this.minVQSLod, this.model.toString(), prev == null ? 0.0 : prev.getTrancheIndex(), this.getTrancheIndex(), this.model.toString(), this.accessibleTruthSites, this.callsAtTruthSites, this.getTruthSensitivity());
    }

    protected static Tranche trancheOfVariants(List<VariantDatum> data, int minI, double ts, VariantRecalibratorArgumentCollection.Mode model) {
        int numKnown = 0;
        int numNovel = 0;
        int knownTi = 0;
        int knownTv = 0;
        int novelTi = 0;
        int novelTv = 0;
        double minLod = data.get((int)minI).lod;
        for (VariantDatum datum : data) {
            if (!(datum.lod >= minLod)) continue;
            if (datum.isKnown) {
                ++numKnown;
                if (!datum.isSNP) continue;
                if (datum.isTransition) {
                    ++knownTi;
                    continue;
                }
                ++knownTv;
                continue;
            }
            ++numNovel;
            if (!datum.isSNP) continue;
            if (datum.isTransition) {
                ++novelTi;
                continue;
            }
            ++novelTv;
        }
        double knownTiTv = (double)knownTi / Math.max(1.0 * (double)knownTv, 1.0);
        double novelTiTv = (double)novelTi / Math.max(1.0 * (double)novelTv, 1.0);
        int accessibleTruthSites = VariantDatum.countCallsAtTruth(data, Double.NEGATIVE_INFINITY);
        int nCallsAtTruth = VariantDatum.countCallsAtTruth(data, minLod);
        return new Tranche("unnamed", knownTiTv, numNovel, minLod, model, novelTiTv, accessibleTruthSites, numKnown, nCallsAtTruth);
    }

    protected static Tranche emptyTranche(List<VariantDatum> data, int minI, double ts, VariantRecalibratorArgumentCollection.Mode model) {
        double minLod = data.isEmpty() ? Double.NEGATIVE_INFINITY : data.get((int)minI).lod;
        int accessibleTruthSites = VariantDatum.countCallsAtTruth(data, Double.NEGATIVE_INFINITY);
        int nCallsAtTruth = VariantDatum.countCallsAtTruth(data, minLod);
        double knownTiTv = 0.0;
        double novelTiTv = 0.0;
        boolean numKnown = false;
        boolean numNovel = false;
        return new Tranche("unnamed", 0.0, 0, minLod, model, 0.0, accessibleTruthSites, 0, nCallsAtTruth);
    }

    protected static double getRequiredDouble(Map<String, String> bindings, String key) {
        if (bindings.containsKey(key)) {
            try {
                return Double.valueOf(bindings.get(key));
            }
            catch (NumberFormatException e) {
                throw new UserException.MalformedFile("Malformed tranches file. Invalid value for key " + key);
            }
        }
        throw new UserException.MalformedFile("Malformed tranches file.  Missing required key " + key);
    }

    protected static double getOptionalDouble(Map<String, String> bindings, String key, double defaultValue) {
        try {
            return Double.valueOf(bindings.getOrDefault(key, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            throw new UserException.MalformedFile("Malformed tranches file. Invalid value for key " + key);
        }
    }

    protected static int getRequiredInteger(Map<String, String> bindings, String key) {
        if (bindings.containsKey(key)) {
            try {
                return Integer.valueOf(bindings.get(key));
            }
            catch (NumberFormatException e) {
                throw new UserException.MalformedFile("Malformed tranches file. Invalid value for key " + key);
            }
        }
        throw new UserException.MalformedFile("Malformed tranches file.  Missing required key " + key);
    }

    protected static int getOptionalInteger(Map<String, String> bindings, String key, int defaultValue) {
        try {
            return Integer.valueOf(bindings.getOrDefault(key, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            throw new UserException.MalformedFile("Malformed tranches file. Invalid value for key " + key);
        }
    }

    protected double getTruthSensitivity() {
        return this.accessibleTruthSites > 0 ? (double)this.callsAtTruthSites / (1.0 * (double)this.accessibleTruthSites) : 0.0;
    }

    public static class TrancheComparator<T extends Tranche>
    implements Comparator<T> {
        @Override
        public int compare(T tranche1, T tranche2) {
            return Double.compare(((Tranche)tranche1).callsAtTruthSites, ((Tranche)tranche2).callsAtTruthSites);
        }
    }

    public static class TrancheTruthSensitivityComparator
    implements Comparator<TruthSensitivityTranche> {
        @Override
        public int compare(TruthSensitivityTranche tranche1, TruthSensitivityTranche tranche2) {
            return Double.compare(tranche1.targetTruthSensitivity, tranche2.targetTruthSensitivity);
        }
    }
}

