/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.vqsr.TruthSensitivityTranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VQSLODTranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantDatum;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantRecalibratorArgumentCollection;

public class TrancheManager {
    protected static final Logger logger = LogManager.getLogger(TrancheManager.class);

    public static List<TruthSensitivityTranche> findTranches(List<VariantDatum> data, List<Double> tranches, SelectionMetric metric, VariantRecalibratorArgumentCollection.Mode model) {
        return TrancheManager.findTranches(data, tranches, metric, model, null);
    }

    public static List<TruthSensitivityTranche> findTranches(List<VariantDatum> data, List<Double> trancheThresholds, SelectionMetric metric, VariantRecalibratorArgumentCollection.Mode model, File debugFile) {
        logger.info(String.format("Finding %d tranches for %d variants", trancheThresholds.size(), data.size()));
        Collections.sort(data, VariantDatum.VariantDatumLODComparator);
        metric.calculateRunningMetric(data);
        if (debugFile != null) {
            TrancheManager.writeTranchesDebuggingInfo(debugFile, data, metric);
        }
        ArrayList<TruthSensitivityTranche> tranches = new ArrayList<TruthSensitivityTranche>();
        for (double trancheThreshold : trancheThresholds) {
            TruthSensitivityTranche t = TrancheManager.findTranche(data, metric, trancheThreshold, model);
            if (t == null) {
                if (tranches.size() != 0) break;
                throw new UserException(String.format("Couldn't find any tranche containing variants with a %s > %.2f. Are you sure the truth files contain unfiltered variants which overlap the input data?", metric.getName(), metric.getThreshold(trancheThreshold)));
            }
            tranches.add(t);
        }
        return tranches;
    }

    public static List<VQSLODTranche> findVQSLODTranches(List<VariantDatum> data, List<Double> trancheThresholds, SelectionMetric metric, VariantRecalibratorArgumentCollection.Mode model) {
        logger.info(String.format("Finding %d tranches for %d variants", trancheThresholds.size(), data.size()));
        Collections.sort(data, VariantDatum.VariantDatumLODComparator);
        metric.calculateRunningMetric(data);
        ArrayList<VQSLODTranche> tranches = new ArrayList<VQSLODTranche>();
        for (double trancheThreshold : trancheThresholds) {
            VQSLODTranche t = TrancheManager.findVQSLODTranche(data, metric, trancheThreshold, model);
            if (t == null) {
                if (tranches.size() != 0) break;
                throw new UserException(String.format("Couldn't find any tranche containing variants with a %s > %.2f. Are you sure the truth files contain unfiltered variants which overlap the input data?", metric.getName(), metric.getThreshold(trancheThreshold)));
            }
            tranches.add(t);
        }
        return tranches;
    }

    private static void writeTranchesDebuggingInfo(File f, List<VariantDatum> tranchesData, SelectionMetric metric) {
        try {
            PrintStream out = new PrintStream(f);
            out.println("Qual metricValue runningValue");
            for (int i = 0; i < tranchesData.size(); ++i) {
                VariantDatum d = tranchesData.get(i);
                int score = metric.datumValue(d);
                double runningValue = metric.getRunningMetric(i);
                out.printf("%.4f %d %.4f%n", d.lod, score, runningValue);
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(f, (Exception)e);
        }
    }

    public static TruthSensitivityTranche findTranche(List<VariantDatum> data, SelectionMetric metric, double trancheThreshold, VariantRecalibratorArgumentCollection.Mode model) {
        logger.info(String.format("  TruthSensitivityTranche threshold %.2f => selection metric threshold %.3f", trancheThreshold, metric.getThreshold(trancheThreshold)));
        double metricThreshold = metric.getThreshold(trancheThreshold);
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            if (!(metric.getRunningMetric(i) >= metricThreshold)) continue;
            TruthSensitivityTranche t = TruthSensitivityTranche.trancheOfVariants(data, i, trancheThreshold, model);
            logger.info(String.format("  Found tranche for %.3f: %.3f threshold starting with variant %d; running score is %.3f ", trancheThreshold, metricThreshold, i, metric.getRunningMetric(i)));
            logger.info(String.format("  TruthSensitivityTranche is %s", t));
            return t;
        }
        return null;
    }

    public static VQSLODTranche findVQSLODTranche(List<VariantDatum> data, SelectionMetric metric, double trancheThreshold, VariantRecalibratorArgumentCollection.Mode model) {
        logger.info(String.format("  VQSLODTranche threshold %.2f => selection metric threshold %.3f", trancheThreshold, metric.getThreshold(trancheThreshold)));
        double metricThreshold = metric.getThreshold(trancheThreshold);
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            if (!(data.get((int)i).lod >= trancheThreshold)) continue;
            VQSLODTranche t = VQSLODTranche.trancheOfVariants(data, i, trancheThreshold, model);
            logger.info(String.format("  Found tranche for %.3f: %.3f threshold starting with variant %d; running score is %.3f ", trancheThreshold, metricThreshold, i, metric.getRunningMetric(i)));
            logger.info(String.format("  VQSLODTranche is %s", t));
            return t;
        }
        logger.info(String.format("  Could not find tranche for %.3f: %.3f threshold; reporting empty tranche", trancheThreshold, metricThreshold));
        VQSLODTranche t = VQSLODTranche.emptyTranche(data, n - 1, trancheThreshold, model);
        return t;
    }

    public static double fdrToTiTv(double desiredFDR, double targetTiTv) {
        return (1.0 - desiredFDR / 100.0) * (targetTiTv - 0.5) + 0.5;
    }

    public static int countCallsAtTruth(List<VariantDatum> data, double minLOD) {
        int n = 0;
        for (VariantDatum d : data) {
            n += d.atTruthSite && d.lod >= minLOD ? 1 : 0;
        }
        return n;
    }

    public static class TruthSensitivityMetric
    extends SelectionMetric {
        double[] runningSensitivity;
        int nTrueSites = 0;

        public TruthSensitivityMetric(int nTrueSites) {
            super("TruthSensitivity");
            this.nTrueSites = nTrueSites;
        }

        @Override
        public double getThreshold(double tranche) {
            return 1.0 - tranche / 100.0;
        }

        @Override
        public double getTarget() {
            return 1.0;
        }

        @Override
        public void calculateRunningMetric(List<VariantDatum> data) {
            int nCalledAtTruth = 0;
            this.runningSensitivity = new double[data.size()];
            for (int i = data.size() - 1; i >= 0; --i) {
                VariantDatum datum = data.get(i);
                this.runningSensitivity[i] = 1.0 - (double)(nCalledAtTruth += datum.atTruthSite ? 1 : 0) / (1.0 * (double)this.nTrueSites);
            }
        }

        @Override
        public double getRunningMetric(int i) {
            return this.runningSensitivity[i];
        }

        @Override
        public int datumValue(VariantDatum d) {
            return d.atTruthSite ? 1 : 0;
        }
    }

    public static abstract class SelectionMetric {
        String name = null;

        public SelectionMetric(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract double getThreshold(double var1);

        public abstract double getTarget();

        public abstract void calculateRunningMetric(List<VariantDatum> var1);

        public abstract double getRunningMetric(int var1);

        public abstract int datumValue(VariantDatum var1);
    }
}

