/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.vqsr.Tranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantDatum;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantRecalibratorArgumentCollection;
import org.broadinstitute.hellbender.utils.text.XReadLines;

final class TruthSensitivityTranche
extends Tranche {
    private static final int CURRENT_VERSION = 5;
    static final Comparator<TruthSensitivityTranche> TRUTH_SENSITIVITY_ORDER = (tranche1, tranche2) -> Double.compare(tranche1.targetTruthSensitivity, tranche2.targetTruthSensitivity);
    private static final Logger logger = LogManager.getLogger(TruthSensitivityTranche.class);
    final double targetTruthSensitivity;

    public TruthSensitivityTranche(double targetTruthSensitivity, double minVQSLod, int numKnown, double knownTiTv, int numNovel, double novelTiTv, int accessibleTruthSites, int callsAtTruthSites, VariantRecalibratorArgumentCollection.Mode model) {
        this(targetTruthSensitivity, minVQSLod, numKnown, knownTiTv, numNovel, novelTiTv, accessibleTruthSites, callsAtTruthSites, model, "anonymous");
    }

    public TruthSensitivityTranche(double targetTruthSensitivity, double minVQSLod, int numKnown, double knownTiTv, int numNovel, double novelTiTv, int accessibleTruthSites, int callsAtTruthSites, VariantRecalibratorArgumentCollection.Mode model, String name) {
        super(name, knownTiTv, numNovel, minVQSLod, model, novelTiTv, accessibleTruthSites, numKnown, callsAtTruthSites);
        if (targetTruthSensitivity < 0.0 || targetTruthSensitivity > 100.0) {
            throw new GATKException("Target FDR is unreasonable " + targetTruthSensitivity);
        }
        if (numKnown < 0 || numNovel < 0) {
            throw new GATKException("Invalid tranche - no. variants is < 0 : known " + numKnown + " novel " + numNovel);
        }
        if (name == null) {
            throw new GATKException("BUG -- name cannot be null");
        }
        this.targetTruthSensitivity = targetTruthSensitivity;
    }

    @Override
    public Double getTrancheIndex() {
        return this.targetTruthSensitivity;
    }

    /*
     * Exception decompiling
     */
    public static String printHeader() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return String.format("TruthSensitivityTranche targetTruthSensitivity=%.2f minVQSLod=%.4f known=(%d @ %.4f) novel=(%d @ %.4f) truthSites(%d accessible, %d called), name=%s]", this.targetTruthSensitivity, this.minVQSLod, this.numKnown, this.knownTiTv, this.numNovel, this.novelTiTv, this.accessibleTruthSites, this.callsAtTruthSites, this.name);
    }

    public static List<TruthSensitivityTranche> readTranches(GATKPath f) throws IOException {
        String[] header = null;
        ArrayList<TruthSensitivityTranche> tranches = new ArrayList<TruthSensitivityTranche>();
        try (XReadLines xrl = new XReadLines(f.toPath());){
            for (String line : xrl) {
                if (line.startsWith("#")) continue;
                String[] vals = line.split(",");
                if (header == null) {
                    header = vals;
                    if (header.length == 11) continue;
                    throw new UserException.MalformedFile(f, "Expected 11 elements in header line " + line);
                }
                if (header.length != vals.length) {
                    throw new UserException.MalformedFile(f, "Line had too few/many fields.  Header = " + header.length + " vals " + vals.length + ". The line was: " + line);
                }
                LinkedHashMap<String, String> bindings = new LinkedHashMap<String, String>();
                for (int i = 0; i < vals.length; ++i) {
                    bindings.put(header[i], vals[i]);
                }
                tranches.add(new TruthSensitivityTranche(TruthSensitivityTranche.getRequiredDouble(bindings, "targetTruthSensitivity"), TruthSensitivityTranche.getRequiredDouble(bindings, "minVQSLod"), TruthSensitivityTranche.getOptionalInteger(bindings, "numKnown", -1), TruthSensitivityTranche.getOptionalDouble(bindings, "knownTiTv", -1.0), TruthSensitivityTranche.getRequiredInteger(bindings, "numNovel"), TruthSensitivityTranche.getRequiredDouble(bindings, "novelTiTv"), TruthSensitivityTranche.getOptionalInteger(bindings, "accessibleTruthSites", -1), TruthSensitivityTranche.getOptionalInteger(bindings, "callsAtTruthSites", -1), VariantRecalibratorArgumentCollection.Mode.valueOf((String)bindings.get("model")), (String)bindings.get("filterName")));
            }
        }
        tranches.sort(TRUTH_SENSITIVITY_ORDER);
        return tranches;
    }

    public static List<TruthSensitivityTranche> findTranches(List<VariantDatum> data, double[] trancheThresholds, TruthSensitivityMetric metric, VariantRecalibratorArgumentCollection.Mode model) {
        logger.info(String.format("Finding %d tranches for %d variants", trancheThresholds.length, data.size()));
        Collections.sort(data, VariantDatum.VariantDatumLODComparator);
        metric.calculateRunningMetric(data);
        ArrayList<TruthSensitivityTranche> tranches = new ArrayList<TruthSensitivityTranche>();
        for (double trancheThreshold : trancheThresholds) {
            TruthSensitivityTranche t = TruthSensitivityTranche.findTranche(data, metric, trancheThreshold, model);
            if (t == null) {
                if (!tranches.isEmpty()) break;
                throw new UserException(String.format("Couldn't find any tranche containing variants with a %s > %.2f. Are you sure the truth files contain unfiltered variants which overlap the input data?", metric.getName(), metric.getThreshold(trancheThreshold)));
            }
            tranches.add(t);
        }
        tranches.sort(TRUTH_SENSITIVITY_ORDER);
        return tranches;
    }

    private static TruthSensitivityTranche findTranche(List<VariantDatum> data, TruthSensitivityMetric metric, double trancheThreshold, VariantRecalibratorArgumentCollection.Mode model) {
        logger.debug(String.format("  TruthSensitivityTranche threshold %.2f => selection metric threshold %.3f", trancheThreshold, metric.getThreshold(trancheThreshold)));
        double metricThreshold = metric.getThreshold(trancheThreshold);
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            if (!(metric.getRunningMetric(i) >= metricThreshold)) continue;
            TruthSensitivityTranche t = TruthSensitivityTranche.trancheOfVariants(data, i, trancheThreshold, model);
            logger.debug(String.format("  Found tranche for %.3f: %.3f threshold starting with variant %d; running score is %.3f ", trancheThreshold, metricThreshold, i, metric.getRunningMetric(i)));
            logger.debug(String.format("  TruthSensitivityTranche is %s", t));
            return t;
        }
        return null;
    }

    protected static TruthSensitivityTranche trancheOfVariants(List<VariantDatum> data, int minI, double ts, VariantRecalibratorArgumentCollection.Mode model) {
        Tranche basicTranche = Tranche.trancheOfVariants(data, minI, ts, model);
        return new TruthSensitivityTranche(ts, basicTranche.minVQSLod, basicTranche.numKnown, basicTranche.knownTiTv, basicTranche.numNovel, basicTranche.novelTiTv, basicTranche.accessibleTruthSites, basicTranche.callsAtTruthSites, model, "anonymous");
    }

    @VisibleForTesting
    static final class TruthSensitivityMetric {
        private final String name;
        private double[] runningSensitivity;
        private final int nTrueSites;

        public TruthSensitivityMetric(int nTrueSites) {
            this.name = "TruthSensitivity";
            this.nTrueSites = nTrueSites;
        }

        public String getName() {
            return this.name;
        }

        public double getThreshold(double tranche) {
            return 1.0 - tranche / 100.0;
        }

        public void calculateRunningMetric(List<VariantDatum> data) {
            int nCalledAtTruth = 0;
            this.runningSensitivity = new double[data.size()];
            for (int i = data.size() - 1; i >= 0; --i) {
                VariantDatum datum = data.get(i);
                this.runningSensitivity[i] = 1.0 - (double)(nCalledAtTruth += datum.atTruthSite ? 1 : 0) / (1.0 * (double)this.nTrueSites);
            }
        }

        public double getRunningMetric(int i) {
            return this.runningSensitivity[i];
        }
    }
}

