/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.vqsr.Tranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.TruthSensitivityTranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantDatum;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantRecalibratorArgumentCollection;
import org.broadinstitute.hellbender.utils.text.XReadLines;

public class VQSLODTranche
extends Tranche {
    private static final int CURRENT_VERSION = 6;

    @Override
    public Double getTrancheIndex() {
        return this.minVQSLod;
    }

    public VQSLODTranche(double minVQSLod, int numKnown, double knownTiTv, int numNovel, double novelTiTv, int accessibleTruthSites, int callsAtTruthSites, VariantRecalibratorArgumentCollection.Mode model, String name) {
        super(name, knownTiTv, numNovel, minVQSLod, model, novelTiTv, accessibleTruthSites, numKnown, callsAtTruthSites);
    }

    public int compareTo(VQSLODTranche t) {
        return (int)Math.round(t.minVQSLod - this.minVQSLod);
    }

    public String toString() {
        return String.format("Tranche minVQSLod=%.4f known=(%d @ %.4f) novel=(%d @ %.4f) truthSites(%d accessible, %d called), name=%s]", this.minVQSLod, this.numKnown, this.knownTiTv, this.numNovel, this.novelTiTv, this.accessibleTruthSites, this.callsAtTruthSites, this.name);
    }

    /*
     * Exception decompiling
     */
    public static String printHeader() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static VQSLODTranche trancheOfVariants(List<VariantDatum> data, int minI, double trancheThreshold, VariantRecalibratorArgumentCollection.Mode model) {
        Tranche basicTranche = Tranche.trancheOfVariants(data, minI, trancheThreshold, model);
        return new VQSLODTranche(trancheThreshold, basicTranche.numKnown, basicTranche.knownTiTv, basicTranche.numNovel, basicTranche.novelTiTv, basicTranche.accessibleTruthSites, basicTranche.callsAtTruthSites, model, "anonymous");
    }

    protected static VQSLODTranche emptyTranche(List<VariantDatum> data, int minI, double trancheThreshold, VariantRecalibratorArgumentCollection.Mode model) {
        Tranche basicTranche = Tranche.emptyTranche(data, minI, trancheThreshold, model);
        return new VQSLODTranche(trancheThreshold, basicTranche.numKnown, basicTranche.knownTiTv, basicTranche.numNovel, basicTranche.novelTiTv, basicTranche.accessibleTruthSites, basicTranche.callsAtTruthSites, model, "anonymous");
    }

    public static List<VQSLODTranche> readTranches(GATKPath f) throws IOException {
        String[] header = null;
        ArrayList<VQSLODTranche> tranches = new ArrayList<VQSLODTranche>();
        try (XReadLines xrl = new XReadLines(f.toPath());){
            for (String line : xrl) {
                if (line.startsWith("#")) {
                    String[] words;
                    if (!line.contains("Version") || Integer.parseInt((words = line.split("\\s+"))[3]) == 6) continue;
                    throw new UserException.BadInput("The file  contains version " + words[3] + " tranches, but VQSLOD tranche parsing requires version " + 6);
                }
                String[] vals = line.split(",");
                if (header == null) {
                    header = vals;
                    if (header.length == 11) continue;
                    throw new UserException.MalformedFile(f, "Expected 11 elements in header line " + line);
                }
                if (header.length != vals.length) {
                    throw new UserException.MalformedFile(f, "Line had too few/many fields.  Header = " + header.length + " vals " + vals.length + ". The line was: " + line);
                }
                LinkedHashMap<String, String> bindings = new LinkedHashMap<String, String>();
                for (int i = 0; i < vals.length; ++i) {
                    bindings.put(header[i], vals[i]);
                }
                tranches.add(new VQSLODTranche(VQSLODTranche.getRequiredDouble(bindings, "minVQSLod"), VQSLODTranche.getOptionalInteger(bindings, "numKnown", -1), VQSLODTranche.getOptionalDouble(bindings, "knownTiTv", -1.0), VQSLODTranche.getRequiredInteger(bindings, "numNovel"), VQSLODTranche.getRequiredDouble(bindings, "novelTiTv"), VQSLODTranche.getOptionalInteger(bindings, "accessibleTruthSites", -1), VQSLODTranche.getOptionalInteger(bindings, "callsAtTruthSites", -1), VariantRecalibratorArgumentCollection.Mode.valueOf((String)bindings.get("model")), (String)bindings.get("filterName")));
            }
        }
        tranches.sort(new Tranche.TrancheComparator());
        return tranches;
    }

    public static List<TruthSensitivityTranche> mergeAndConvertTranches(TreeMap<Double, List<VQSLODTranche>> scatteredTranches, List<Double> tsLevels, VariantRecalibratorArgumentCollection.Mode mode) {
        ArrayList<VQSLODTranche> mergedTranches = new ArrayList<VQSLODTranche>();
        ArrayList<TruthSensitivityTranche> gatheredTranches = new ArrayList<TruthSensitivityTranche>();
        for (Double VQSLODlevel : scatteredTranches.descendingKeySet()) {
            mergedTranches.add(VQSLODTranche.mergeAndConvertTranches(scatteredTranches.get(VQSLODlevel), mode));
        }
        Collections.sort(tsLevels);
        ListIterator<Double> tsIter = tsLevels.listIterator();
        double targetTS = tsIter.next();
        double sensitivityDelta = 100.0;
        ListIterator trancheIter = mergedTranches.listIterator();
        VQSLODTranche currentTranche = (VQSLODTranche)trancheIter.next();
        while (trancheIter.hasNext()) {
            double prevDelta = sensitivityDelta;
            VQSLODTranche prevTranche = currentTranche;
            currentTranche = (VQSLODTranche)trancheIter.next();
            sensitivityDelta = Math.abs(targetTS - currentTranche.getTruthSensitivity() * 100.0);
            if (sensitivityDelta > prevDelta) {
                gatheredTranches.add(new TruthSensitivityTranche(targetTS, prevTranche.minVQSLod, prevTranche.numKnown, prevTranche.knownTiTv, prevTranche.numNovel, prevTranche.novelTiTv, prevTranche.accessibleTruthSites, prevTranche.callsAtTruthSites, mode));
                if (!tsIter.hasNext()) break;
                targetTS = tsIter.next();
                sensitivityDelta = Math.abs(targetTS - currentTranche.getTruthSensitivity() * 100.0);
            }
            if (trancheIter.hasNext()) continue;
            gatheredTranches.add(new TruthSensitivityTranche(targetTS, currentTranche.minVQSLod, currentTranche.numKnown, currentTranche.knownTiTv, currentTranche.numNovel, currentTranche.novelTiTv, currentTranche.accessibleTruthSites, currentTranche.callsAtTruthSites, mode));
        }
        return gatheredTranches;
    }

    public static VQSLODTranche mergeAndConvertTranches(List<VQSLODTranche> scatteredTranches, VariantRecalibratorArgumentCollection.Mode mode) {
        double indexVQSLOD = scatteredTranches.get((int)0).minVQSLod;
        int sumNumKnown = 0;
        double sumKnownTransitions = 0.0;
        double sumKnownTransversions = 0.0;
        int sumNumNovel = 0;
        double sumNovelTransitions = 0.0;
        double sumNovelTransversions = 0.0;
        int sumAccessibleTruthSites = 0;
        int sumCallsAtTruthSites = 0;
        for (VQSLODTranche tranche : scatteredTranches) {
            if (tranche.minVQSLod != indexVQSLOD) {
                throw new IllegalStateException("Scattered tranches do not contain the same VQSLODs");
            }
            sumNumKnown += tranche.numKnown;
            double trancheKnownTransitions = tranche.knownTiTv * (double)tranche.numKnown / (1.0 + tranche.knownTiTv);
            sumKnownTransitions += trancheKnownTransitions;
            sumKnownTransversions += (double)tranche.numKnown - trancheKnownTransitions;
            sumNumNovel += tranche.numNovel;
            double trancheNovelTransitions = tranche.novelTiTv * (double)tranche.numNovel / (1.0 + tranche.novelTiTv);
            sumNovelTransitions += trancheNovelTransitions;
            sumNovelTransversions += (double)tranche.numNovel - trancheNovelTransitions;
            sumAccessibleTruthSites += tranche.accessibleTruthSites;
            sumCallsAtTruthSites += tranche.callsAtTruthSites;
        }
        return new VQSLODTranche(indexVQSLOD, sumNumKnown, sumKnownTransitions / sumKnownTransversions, sumNumNovel, sumNovelTransitions / sumNovelTransversions, sumAccessibleTruthSites, sumCallsAtTruthSites, mode, "gathered" + indexVQSLOD);
    }
}

