/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.Allele;
import java.util.Comparator;
import java.util.List;
import org.broadinstitute.hellbender.tools.walkers.vqsr.MultivariateGaussian;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;

final class VariantDatum {
    public double[] annotations;
    public boolean[] isNull;
    public boolean isKnown;
    public double lod;
    public boolean atTruthSite;
    public boolean atTrainingSite;
    public boolean atAntiTrainingSite;
    public boolean isTransition;
    public boolean isSNP;
    public boolean failingSTDThreshold;
    public double originalQual;
    public double prior;
    public SimpleInterval loc;
    public int worstAnnotation;
    public double worstValue;
    public MultivariateGaussian assignment;
    public boolean isAggregate;
    public Allele referenceAllele;
    public Allele alternateAllele;
    public static final Comparator<VariantDatum> VariantDatumLODComparator = (datum1, datum2) -> Double.compare(datum1.lod, datum2.lod);

    VariantDatum() {
    }

    public static int countCallsAtTruth(List<VariantDatum> data, double minLOD) {
        return (int)data.stream().filter(d -> d.atTruthSite && d.lod >= minLOD).count();
    }

    public static Comparator<VariantDatum> getComparator(SAMSequenceDictionary seqDictionary) {
        return (vd1, vd2) -> IntervalUtils.compareLocatables(vd1.loc, vd2.loc, seqDictionary);
    }
}

