/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import Jama.Matrix;
import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.MultiVariantWalker;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.vqsr.GaussianMixtureModel;
import org.broadinstitute.hellbender.tools.walkers.vqsr.MultivariateGaussian;
import org.broadinstitute.hellbender.tools.walkers.vqsr.TrainingSet;
import org.broadinstitute.hellbender.tools.walkers.vqsr.Tranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.TrancheManager;
import org.broadinstitute.hellbender.tools.walkers.vqsr.TruthSensitivityTranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VQSLODTranche;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantDataManager;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantDatum;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantRecalibrationUtils;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantRecalibratorArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantRecalibratorEngine;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.R.RScriptExecutor;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.report.GATKReport;
import org.broadinstitute.hellbender.utils.report.GATKReportColumn;
import org.broadinstitute.hellbender.utils.report.GATKReportTable;
import org.broadinstitute.hellbender.utils.variant.GATKVCFConstants;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.VcfUtils;
import picard.cmdline.programgroups.VariantFilteringProgramGroup;

@CommandLineProgramProperties(summary="Build a recalibration model to score variant quality for filtering purposes", oneLineSummary="Build a recalibration model to score variant quality for filtering purposes", programGroup=VariantFilteringProgramGroup.class)
@DocumentedFeature
public class VariantRecalibrator
extends MultiVariantWalker {
    private static final String PLOT_TRANCHES_RSCRIPT = "plot_Tranches.R";
    @ArgumentCollection
    private final VariantRecalibratorArgumentCollection VRAC = new VariantRecalibratorArgumentCollection();
    @Argument(fullName="aggregate", shortName="aggregate", doc="Additional raw input variants to be used in building the model", optional=true)
    private List<FeatureInput<VariantContext>> aggregate = new ArrayList<FeatureInput<VariantContext>>();
    @Argument(fullName="resource", doc="A list of sites for which to apply a prior probability of being correct but which aren't used by the algorithm (training and truth sets are required to run)", optional=false)
    private List<FeatureInput<VariantContext>> resource = new ArrayList<FeatureInput<VariantContext>>();
    @Argument(fullName="output", shortName="O", doc="The output recal file used by ApplyVQSR", optional=false)
    private GATKPath output;
    @Argument(fullName="tranches-file", doc="The output tranches file used by ApplyVQSR", optional=false)
    private File TRANCHES_FILE;
    @Argument(fullName="target-titv", shortName="titv", doc="The expected novel Ti/Tv ratio to use when calculating FDR tranches and for display on the optimization curve output figures. (approx 2.15 for whole genome experiments). ONLY USED FOR PLOTTING PURPOSES!", optional=true)
    private double TARGET_TITV = 2.15;
    @Argument(fullName="use-annotation", shortName="an", doc="The names of the annotations which should used for calculations", optional=false)
    private List<String> USE_ANNOTATIONS = new ArrayList<String>();
    @Argument(fullName="truth-sensitivity-tranche", shortName="tranche", doc="The levels of truth sensitivity at which to slice the data. (in percent, that is 1.0 for 1 percent)", optional=true)
    private List<Double> TS_TRANCHES = new ArrayList<Double>(Arrays.asList(100.0, 99.9, 99.0, 90.0));
    @Argument(fullName="ignore-filter", doc="If specified, the variant recalibrator will also use variants marked as filtered by the specified filter name in the input VCF file", optional=true)
    private List<String> IGNORE_INPUT_FILTERS = new ArrayList<String>();
    @Argument(fullName="ignore-all-filters", doc="If specified, the variant recalibrator will ignore all input filters. Useful to rerun the VQSR from a filtered output file.", optional=true)
    private boolean IGNORE_ALL_FILTERS = false;
    @Argument(fullName="rscript-file", doc="The output rscript file generated by the VQSR to aid in visualization of the input data and learned model", optional=true)
    private File RSCRIPT_FILE = null;
    @Argument(fullName="output-model", doc="If specified, the variant recalibrator will output the VQSR model to this file path.", optional=true)
    private GATKPath outputModel = null;
    @Argument(fullName="input-model", doc="If specified, the variant recalibrator will read the VQSR model from this file path.", optional=true)
    private GATKPath inputModel = null;
    @Argument(fullName="sample-every-Nth-variant", shortName="sample-every", doc="If specified, the variant recalibrator will use (and output) only a subset of variants consisting of every Nth variant where N is specified by this argument; for use with --output-model -- see argument details", optional=true)
    @Hidden
    private int sampleMod = 1;
    @Argument(fullName="output-tranches-for-scatter", doc="Output tranches in a format appropriate to running VariantRecalibrator in scatter-gather", optional=true)
    @Hidden
    private boolean scatterTranches = false;
    @Hidden
    @Argument(fullName="vqslod-tranche", doc="The levels of VQSLOD at which to slice the data.", optional=true)
    private List<Double> VQSLOD_TRANCHES = new ArrayList<Double>(1000);
    @Hidden
    @Argument(fullName="replicate", shortName="replicate", doc="Used to debug the random number generation inside the VQSR. Do not use.", optional=true)
    private int REPLICATE;
    @Advanced
    @Argument(fullName="max-attempts", doc="Number of attempts to build a model before failing", optional=true)
    @VisibleForTesting
    protected int max_attempts;
    @Advanced
    @Argument(fullName="trust-all-polymorphic", doc="Trust that all the input training sets' unfiltered records contain only polymorphic sites to drastically speed up the computation.", optional=true)
    private boolean TRUST_ALL_POLYMORPHIC;
    @VisibleForTesting
    protected List<Integer> annotationOrder;
    private VariantDataManager dataManager;
    private VariantContextWriter recalWriter;
    private PrintStream tranchesStream;
    private final ArrayList<Double> replicate;
    private final Set<String> ignoreInputFilterSet;
    private final VariantRecalibratorEngine engine;
    private final ArrayList<VariantDatum> reduceSum;
    private final List<ImmutablePair<VariantContext, FeatureContext>> variantsAtLocus;
    private long counter;
    private GATKReportTable nmcTable;
    private GATKReportTable nmmTable;
    private GATKReportTable nPMixTable;
    private GATKReportTable pmcTable;
    private GATKReportTable pmmTable;
    private GATKReportTable pPMixTable;
    private int numAnnotations;
    private RScriptExecutor rScriptExecutor;

    public VariantRecalibrator() {
        double i;
        for (i = 10.0; i > 5.0; i -= 0.1) {
            this.VQSLOD_TRANCHES.add(i);
        }
        for (i = 5.0; i > -5.0; i -= 0.01) {
            this.VQSLOD_TRANCHES.add(i);
        }
        for (i = -5.0; i > -10.0; i -= 0.1) {
            this.VQSLOD_TRANCHES.add(i);
        }
        this.REPLICATE = 200;
        this.max_attempts = 1;
        this.TRUST_ALL_POLYMORPHIC = false;
        this.annotationOrder = null;
        this.replicate = new ArrayList(this.REPLICATE * 2);
        this.ignoreInputFilterSet = new TreeSet<String>();
        this.engine = new VariantRecalibratorEngine(this.VRAC);
        this.reduceSum = new ArrayList(2000);
        this.variantsAtLocus = new ArrayList<ImmutablePair<VariantContext, FeatureContext>>();
        this.counter = 0L;
    }

    @Override
    public void onTraversalStart() {
        this.dataManager = new VariantDataManager(new ArrayList<String>(this.USE_ANNOTATIONS), this.VRAC);
        if (this.RSCRIPT_FILE != null) {
            this.rScriptExecutor = new RScriptExecutor();
            if (!this.rScriptExecutor.externalExecutableExists()) {
                Utils.warnUser(this.logger, String.format("Rscript not found in environment path. %s will be generated but PDF plots will not.", this.RSCRIPT_FILE));
            }
        }
        if (this.IGNORE_INPUT_FILTERS != null) {
            this.ignoreInputFilterSet.addAll(this.IGNORE_INPUT_FILTERS);
        }
        try {
            this.tranchesStream = new PrintStream(this.TRANCHES_FILE);
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(this.TRANCHES_FILE, (Exception)e);
        }
        for (FeatureInput<VariantContext> featureInput : this.resource) {
            this.dataManager.addTrainingSet(new TrainingSet(featureInput));
        }
        if (!this.dataManager.checkHasTrainingSet()) {
            throw new CommandLineException("No training set found! Please provide sets of known polymorphic loci marked with the training=true feature input tag. For example, -resource hapmap,VCF,known=false,training=true,truth=true,prior=12.0 hapmapFile.vcf");
        }
        if (!this.dataManager.checkHasTruthSet()) {
            throw new CommandLineException("No truth set found! Please provide sets of known polymorphic loci marked with the truth=true feature input tag. For example, -resource hapmap,VCF,known=false,training=true,truth=true,prior=12.0 hapmapFile.vcf");
        }
        if (this.inputModel != null) {
            this.logger.info("Loading model from:" + this.inputModel);
            try {
                Throwable throwable = null;
                try (InputStream is = this.inputModel.getInputStream();){
                    GATKReport reportIn = new GATKReport(is);
                    this.nmcTable = reportIn.getTable("NegativeModelCovariances");
                    this.nmmTable = reportIn.getTable("NegativeModelMeans");
                    this.nPMixTable = reportIn.getTable("BadGaussianPMix");
                    this.pmcTable = reportIn.getTable("PositiveModelCovariances");
                    this.pmmTable = reportIn.getTable("PositiveModelMeans");
                    this.pPMixTable = reportIn.getTable("GoodGaussianPMix");
                    GATKReportTable anMeansTable = reportIn.getTable("AnnotationMeans");
                    GATKReportTable anStDevsTable = reportIn.getTable("AnnotationStdevs");
                    this.orderAndValidateAnnotations(anMeansTable, this.dataManager.annotationKeys);
                    this.numAnnotations = this.annotationOrder.size();
                    Map<String, Double> anMeans = this.getMapFromVectorTable(anMeansTable);
                    Map<String, Double> anStdDevs = this.getMapFromVectorTable(anStDevsTable);
                    this.dataManager.setNormalization(anMeans, anStdDevs);
                }
                catch (Throwable reportIn) {
                    Throwable throwable2 = reportIn;
                    throw reportIn;
                }
            }
            catch (IOException e) {
                throw new UserException.CouldNotReadInputFile("File: (" + this.inputModel + ")", (Exception)e);
            }
        }
        Set<VCFHeaderLine> hInfo = this.getDefaultToolVCFHeaderLines();
        VariantRecalibrationUtils.addVQSRStandardHeaderLines(hInfo);
        SAMSequenceDictionary sAMSequenceDictionary = this.getBestAvailableSequenceDictionary();
        if (this.hasReference()) {
            hInfo = VcfUtils.updateHeaderContigLines(hInfo, this.referenceArguments.getReferencePath(), sAMSequenceDictionary, true);
        } else if (null != sAMSequenceDictionary) {
            hInfo = VcfUtils.updateHeaderContigLines(hInfo, null, sAMSequenceDictionary, true);
        }
        this.recalWriter = this.createVCFWriter(this.output);
        this.recalWriter.writeHeader(new VCFHeader(hInfo));
        for (int iii = 0; iii < this.REPLICATE * 2; ++iii) {
            this.replicate.add(Utils.getRandomGenerator().nextDouble());
        }
    }

    protected void orderAndValidateAnnotations(GATKReportTable annotationTable, List<String> annotationKeys) {
        this.annotationOrder = new ArrayList<Integer>(annotationKeys.size());
        for (int i = 0; i < annotationTable.getNumRows(); ++i) {
            String serialAnno = (String)annotationTable.get(i, "Annotation");
            for (int j = 0; j < annotationKeys.size(); ++j) {
                if (!serialAnno.equals(annotationKeys.get(j))) continue;
                this.annotationOrder.add(j);
            }
        }
        if (this.annotationOrder.size() != annotationTable.getNumRows() || this.annotationOrder.size() != annotationKeys.size()) {
            throw new CommandLineException("Annotations specified on the command line do not match annotations in the model report.");
        }
    }

    @Override
    public void apply(VariantContext vc, ReadsContext readsContext, ReferenceContext ref, FeatureContext featureContext) {
        if (this.variantLocusChanged(vc)) {
            this.consumeQueuedVariants();
        }
        if (this.counter % (long)this.sampleMod == 0L) {
            this.variantsAtLocus.add((ImmutablePair<VariantContext, FeatureContext>)new ImmutablePair((Object)vc, (Object)featureContext));
        }
        ++this.counter;
    }

    private boolean variantLocusChanged(VariantContext nextVC) {
        if (this.variantsAtLocus.isEmpty()) {
            return false;
        }
        ImmutablePair<VariantContext, FeatureContext> previous = this.variantsAtLocus.get(0);
        return nextVC.getStart() != ((VariantContext)previous.left).getStart() || !nextVC.getContig().equals(((VariantContext)previous.left).getContig());
    }

    private void consumeQueuedVariants() {
        this.variantsAtLocus.forEach(v -> this.addVariantDatum((VariantContext)v.left, true, (FeatureContext)v.right));
        if (!this.aggregate.isEmpty()) {
            this.addOverlappingAggregateVariants(this.aggregate, false, (FeatureContext)this.variantsAtLocus.get(0).getRight());
        }
        this.variantsAtLocus.clear();
    }

    private void addOverlappingAggregateVariants(List<FeatureInput<VariantContext>> aggregateInputs, boolean isInput, FeatureContext context) {
        if (aggregateInputs == null) {
            throw new IllegalArgumentException("aggregateInputs cannot be null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        for (VariantContext vc : context.getValues(aggregateInputs, context.getInterval().getStart())) {
            this.addVariantDatum(vc, isInput, context);
        }
    }

    private void addVariantDatum(VariantContext vc, boolean isInput, FeatureContext context) {
        if (vc != null && (this.IGNORE_ALL_FILTERS || vc.isNotFiltered() || this.ignoreInputFilterSet.containsAll(vc.getFilters()))) {
            if (VariantDataManager.checkVariationClass(vc, this.VRAC.MODE) && !this.VRAC.useASannotations) {
                this.addDatum(this.reduceSum, isInput, context, vc, null, null);
            } else if (this.VRAC.useASannotations) {
                for (Allele allele : vc.getAlternateAlleles()) {
                    if (GATKVCFConstants.isSpanningDeletion(allele) || !VariantDataManager.checkVariationClass(vc, allele, this.VRAC.MODE)) continue;
                    this.addDatum(this.reduceSum, isInput, context, vc, vc.getReference(), allele);
                }
            }
        }
    }

    private void addDatum(ArrayList<VariantDatum> variants, boolean isInput, FeatureContext featureContext, VariantContext vc, Allele refAllele, Allele altAllele) {
        VariantDatum datum = new VariantDatum();
        datum.referenceAllele = refAllele;
        datum.alternateAllele = altAllele;
        this.dataManager.decodeAnnotations(datum, vc, true);
        datum.loc = isInput ? new SimpleInterval((Locatable)vc) : null;
        datum.originalQual = vc.getPhredScaledQual();
        datum.isSNP = vc.isSNP() && vc.isBiallelic();
        datum.isTransition = datum.isSNP && GATKVariantContextUtils.isTransition(vc);
        datum.isAggregate = !isInput;
        this.dataManager.parseTrainingSets(featureContext, vc, datum, this.TRUST_ALL_POLYMORPHIC);
        double priorFactor = QualityUtils.qualToProb(datum.prior);
        datum.prior = Math.log10(priorFactor) - Math.log10(1.0 - priorFactor);
        variants.add(datum);
    }

    @Override
    public Object onTraversalSuccess() {
        this.consumeQueuedVariants();
        for (int i = 1; i <= this.max_attempts; ++i) {
            try {
                GaussianMixtureModel badModel;
                List<VariantDatum> negativeTrainingData;
                GaussianMixtureModel goodModel;
                this.dataManager.setData(this.reduceSum);
                this.dataManager.normalizeData(this.inputModel == null, this.annotationOrder);
                List<VariantDatum> positiveTrainingData = this.dataManager.getTrainingData();
                if (this.inputModel != null) {
                    this.logger.info("Using serialized GMMs from file...");
                    goodModel = this.GMMFromTables(this.pmmTable, this.pmcTable, this.pPMixTable, this.numAnnotations, positiveTrainingData.size());
                    this.engine.evaluateData(this.dataManager.getData(), goodModel, false);
                    negativeTrainingData = this.dataManager.selectWorstVariants();
                    badModel = this.GMMFromTables(this.nmmTable, this.nmcTable, this.nPMixTable, this.numAnnotations, negativeTrainingData.size());
                } else {
                    goodModel = this.engine.generateModel(positiveTrainingData, this.VRAC.MAX_GAUSSIANS);
                    this.engine.evaluateData(this.dataManager.getData(), goodModel, false);
                    if (goodModel.failedToConverge) {
                        if (this.outputModel != null) {
                            GATKReport report = this.writeModelReport(goodModel, null, this.USE_ANNOTATIONS);
                            VariantRecalibrator.saveModelReport(report, this.outputModel);
                        }
                        throw new UserException.VQSRPositiveModelFailure("Positive training model failed to converge.  One or more annotations (usually MQ) may have insufficient variance.  Please consider lowering the maximum number of Gaussians allowed for use in the model (via --max-gaussians 4, for example).");
                    }
                    negativeTrainingData = this.dataManager.selectWorstVariants();
                    badModel = this.engine.generateModel(negativeTrainingData, Math.min(this.VRAC.MAX_GAUSSIANS_FOR_NEGATIVE_MODEL, this.VRAC.MAX_GAUSSIANS));
                    if (badModel.failedToConverge) {
                        throw new UserException.VQSRNegativeModelFailure("NaN LOD value assigned. Clustering with this few variants and these annotations is unsafe. Please consider raising the number of variants used to train the negative model (via --minimum-bad-variants 5000, for example).");
                    }
                }
                this.dataManager.dropAggregateData();
                this.engine.evaluateData(this.dataManager.getData(), badModel, true);
                if (this.outputModel != null) {
                    GATKReport report = this.writeModelReport(goodModel, badModel, this.USE_ANNOTATIONS);
                    VariantRecalibrator.saveModelReport(report, this.outputModel);
                }
                this.engine.calculateWorstPerformingAnnotation(this.dataManager.getData(), goodModel, badModel);
                int nCallsAtTruth = TrancheManager.countCallsAtTruth(this.dataManager.getData(), Double.NEGATIVE_INFINITY);
                TrancheManager.TruthSensitivityMetric metric = new TrancheManager.TruthSensitivityMetric(nCallsAtTruth);
                if (!this.scatterTranches) {
                    List<TruthSensitivityTranche> tranches = TrancheManager.findTranches(this.dataManager.getData(), this.TS_TRANCHES, metric, this.VRAC.MODE);
                    this.tranchesStream.print(TruthSensitivityTranche.printHeader());
                    this.tranchesStream.print(Tranche.tranchesString(tranches));
                } else {
                    List<VQSLODTranche> tranches = TrancheManager.findVQSLODTranches(this.dataManager.getData(), this.VQSLOD_TRANCHES, metric, this.VRAC.MODE);
                    this.tranchesStream.print(VQSLODTranche.printHeader());
                    this.tranchesStream.print(Tranche.tranchesString(tranches));
                }
                this.logger.info("Writing out recalibration table...");
                this.dataManager.writeOutRecalibrationTable(this.recalWriter, this.getBestAvailableSequenceDictionary());
                if (this.RSCRIPT_FILE != null) {
                    this.logger.info("Writing out visualization Rscript file...");
                    this.createVisualizationScript(this.dataManager.getRandomDataForPlotting(1000, positiveTrainingData, negativeTrainingData, this.dataManager.getEvaluationData()), goodModel, badModel, 0.0, this.dataManager.getAnnotationKeys().toArray(new String[this.USE_ANNOTATIONS.size()]));
                }
                if (this.VRAC.MODE == VariantRecalibratorArgumentCollection.Mode.INDEL) {
                    this.logger.info("Tranches plot will not be generated since we are running in INDEL mode");
                } else if (this.scatterTranches) {
                    this.logger.info("Tranches plot will not be generated since we are running in scattered mode");
                } else if (this.RSCRIPT_FILE != null) {
                    this.rScriptExecutor.addScript(new Resource(PLOT_TRANCHES_RSCRIPT, VariantRecalibrator.class));
                    this.rScriptExecutor.addArgs(this.TRANCHES_FILE.getAbsoluteFile(), this.TARGET_TITV);
                    this.logger.info("Executing: " + this.rScriptExecutor.getApproximateCommandLine());
                    this.rScriptExecutor.exec();
                }
                return true;
            }
            catch (Exception e) {
                if (i == this.max_attempts) {
                    throw e;
                }
                this.logger.info(String.format("Exception occurred on attempt %d of %d. Trying again. Message was: '%s'", i, this.max_attempts, e.getMessage()));
                continue;
            }
        }
        return false;
    }

    @Override
    public void closeTool() {
        if (this.recalWriter != null) {
            this.recalWriter.close();
        }
        if (this.tranchesStream != null) {
            this.tranchesStream.close();
        }
    }

    protected GaussianMixtureModel GMMFromTables(GATKReportTable muTable, GATKReportTable sigmaTable, GATKReportTable pmixTable, int numAnnotations, int numVariants) {
        int row;
        ArrayList<MultivariateGaussian> gaussianList = new ArrayList<MultivariateGaussian>();
        int curAnnotation = 0;
        for (GATKReportColumn reportColumn : muTable.getColumnInfo()) {
            if (reportColumn.getColumnName().equals("Gaussian")) continue;
            for (row = 0; row < muTable.getNumRows(); ++row) {
                if (gaussianList.size() <= row) {
                    MultivariateGaussian mg = new MultivariateGaussian(numVariants, numAnnotations);
                    gaussianList.add(mg);
                }
                ((MultivariateGaussian)gaussianList.get((int)row)).mu[curAnnotation] = (Double)muTable.get(row, reportColumn.getColumnName());
            }
            ++curAnnotation;
        }
        for (GATKReportColumn reportColumn : pmixTable.getColumnInfo()) {
            if (!reportColumn.getColumnName().equals("pMixLog10")) continue;
            for (row = 0; row < pmixTable.getNumRows(); ++row) {
                ((MultivariateGaussian)gaussianList.get((int)row)).pMixtureLog10 = (Double)pmixTable.get(row, reportColumn.getColumnName());
            }
        }
        int curJ = 0;
        for (GATKReportColumn reportColumn : sigmaTable.getColumnInfo()) {
            if (reportColumn.getColumnName().equals("Gaussian") || reportColumn.getColumnName().equals("Annotation")) continue;
            for (int row2 = 0; row2 < sigmaTable.getNumRows(); ++row2) {
                int curGaussian = row2 / numAnnotations;
                int curI = row2 % numAnnotations;
                double curVal = (Double)sigmaTable.get(row2, reportColumn.getColumnName());
                ((MultivariateGaussian)gaussianList.get((int)curGaussian)).sigma.set(curI, curJ, curVal);
            }
            ++curJ;
        }
        return new GaussianMixtureModel(gaussianList, this.VRAC.SHRINKAGE, this.VRAC.DIRICHLET_PARAMETER, this.VRAC.PRIOR_COUNTS);
    }

    private Map<String, Double> getMapFromVectorTable(GATKReportTable vectorTable) {
        HashMap<String, Double> dataMap = new HashMap<String, Double>();
        for (int i = 0; i < vectorTable.getNumRows(); ++i) {
            dataMap.put((String)vectorTable.get(i, 0), (Double)vectorTable.get(i, 1));
        }
        return dataMap;
    }

    protected GATKReport writeModelReport(GaussianMixtureModel goodModel, GaussianMixtureModel badModel, List<String> annotationList) {
        String formatString = "%.16E";
        GATKReport report = new GATKReport();
        if (this.dataManager != null) {
            double[] meanVector = this.dataManager.getMeanVector();
            GATKReportTable annotationMeans = this.makeVectorTable("AnnotationMeans", "Mean for each annotation, used to normalize data", this.dataManager.annotationKeys, meanVector, "Mean", "%.16E");
            report.addTable(annotationMeans);
            double[] varianceVector = this.dataManager.getVarianceVector();
            GATKReportTable annotationVariances = this.makeVectorTable("AnnotationStdevs", "Standard deviation for each annotation, used to normalize data", this.dataManager.annotationKeys, varianceVector, "StandardDeviation", "%.16E");
            report.addTable(annotationVariances);
        }
        ArrayList<String> gaussianStrings = new ArrayList<String>();
        double[] pMixtureLog10s = new double[goodModel.getModelGaussians().size()];
        int idx = 0;
        for (MultivariateGaussian gaussian : goodModel.getModelGaussians()) {
            pMixtureLog10s[idx] = gaussian.pMixtureLog10;
            gaussianStrings.add(Integer.toString(idx++));
        }
        GATKReportTable goodPMix = this.makeVectorTable("GoodGaussianPMix", "Pmixture log 10 used to evaluate model", gaussianStrings, pMixtureLog10s, "pMixLog10", "%.16E", "Gaussian");
        report.addTable(goodPMix);
        if (badModel != null) {
            gaussianStrings.clear();
            double[] pMixtureLog10sBad = new double[badModel.getModelGaussians().size()];
            idx = 0;
            for (MultivariateGaussian gaussian : badModel.getModelGaussians()) {
                pMixtureLog10sBad[idx] = gaussian.pMixtureLog10;
                gaussianStrings.add(Integer.toString(idx++));
            }
            GATKReportTable badPMix = this.makeVectorTable("BadGaussianPMix", "Pmixture log 10 used to evaluate model", gaussianStrings, pMixtureLog10sBad, "pMixLog10", "%.16E", "Gaussian");
            report.addTable(badPMix);
        }
        GATKReportTable positiveMeans = this.makeMeansTable("PositiveModelMeans", "Vector of annotation values to describe the (normalized) mean for each Gaussian in the positive model", annotationList, goodModel, "%.16E");
        report.addTable(positiveMeans);
        GATKReportTable positiveCovariance = this.makeCovariancesTable("PositiveModelCovariances", "Matrix to describe the (normalized) covariance for each Gaussian in the positive model; covariance matrices are joined by row", annotationList, goodModel, "%.16E");
        report.addTable(positiveCovariance);
        if (badModel != null) {
            GATKReportTable negativeMeans = this.makeMeansTable("NegativeModelMeans", "Vector of annotation values to describe the (normalized) mean for each Gaussian in the negative model", annotationList, badModel, "%.16E");
            report.addTable(negativeMeans);
            GATKReportTable negativeCovariance = this.makeCovariancesTable("NegativeModelCovariances", "Matrix to describe the (normalized) covariance for each Gaussian in the negative model; covariance matrices are joined by row", annotationList, badModel, "%.16E");
            report.addTable(negativeCovariance);
        }
        return report;
    }

    private static void saveModelReport(GATKReport report, GATKPath modelPath) {
        try (PrintStream modelReportStream = new PrintStream(modelPath.getOutputStream());){
            if (modelReportStream.checkError()) {
                throw new IOException("checkError failure condition in PrintStream constructor");
            }
            report.print(modelReportStream);
            if (modelReportStream.checkError()) {
                throw new IOException("checkError failure condition in output writing");
            }
        }
        catch (Exception e) {
            throw new UserException.CouldNotCreateOutputFile(modelPath, "Exception writing to report output. ", e);
        }
    }

    protected GATKReportTable makeVectorTable(String tableName, String tableDescription, List<String> annotationList, double[] perAnnotationValues, String columnName, String formatString) {
        return this.makeVectorTable(tableName, tableDescription, annotationList, perAnnotationValues, columnName, formatString, "Annotation");
    }

    private GATKReportTable makeVectorTable(String tableName, String tableDescription, List<String> annotationList, double[] perAnnotationValues, String columnName, String formatString, String firstColumn) {
        GATKReportTable vectorTable = new GATKReportTable(tableName, tableDescription, annotationList.size(), GATKReportTable.Sorting.DO_NOT_SORT);
        vectorTable.addColumn(firstColumn, "");
        vectorTable.addColumn(columnName, formatString);
        for (int i = 0; i < perAnnotationValues.length; ++i) {
            vectorTable.addRowIDMapping(annotationList.get(i), i, true);
            vectorTable.set(i, 1, (Object)perAnnotationValues[i]);
        }
        return vectorTable;
    }

    private GATKReportTable makeMeansTable(String tableName, String tableDescription, List<String> annotationList, GaussianMixtureModel model, String formatString) {
        GATKReportTable meansTable = new GATKReportTable(tableName, tableDescription, annotationList.size(), GATKReportTable.Sorting.DO_NOT_SORT);
        meansTable.addColumn("Gaussian", "");
        for (String annotationName : annotationList) {
            meansTable.addColumn(annotationName, formatString);
        }
        List<MultivariateGaussian> modelGaussians = model.getModelGaussians();
        for (int i = 0; i < modelGaussians.size(); ++i) {
            MultivariateGaussian gaussian = modelGaussians.get(i);
            double[] meanVec = gaussian.mu;
            if (meanVec.length != annotationList.size()) {
                throw new IllegalStateException("Gaussian mean vector does not have the same size as the list of annotations");
            }
            meansTable.addRowIDMapping(i, i, true);
            for (int j = 0; j < annotationList.size(); ++j) {
                meansTable.set((Object)i, annotationList.get(j), (Object)meanVec[j]);
            }
        }
        return meansTable;
    }

    private GATKReportTable makeCovariancesTable(String tableName, String tableDescription, List<String> annotationList, GaussianMixtureModel model, String formatString) {
        GATKReportTable modelCovariances = new GATKReportTable(tableName, tableDescription, annotationList.size() + 2, GATKReportTable.Sorting.DO_NOT_SORT);
        modelCovariances.addColumn("Gaussian", "");
        modelCovariances.addColumn("Annotation", "");
        for (String annotationName : annotationList) {
            modelCovariances.addColumn(annotationName, formatString);
        }
        List<MultivariateGaussian> modelGaussians = model.getModelGaussians();
        for (int i = 0; i < modelGaussians.size(); ++i) {
            MultivariateGaussian gaussian = modelGaussians.get(i);
            Matrix covMat = gaussian.sigma;
            if (covMat.getRowDimension() != annotationList.size() || covMat.getColumnDimension() != annotationList.size()) {
                throw new IllegalStateException("Gaussian covariance matrix does not have the same size as the list of annotations");
            }
            for (int j = 0; j < annotationList.size(); ++j) {
                modelCovariances.set((Object)(j + i * annotationList.size()), "Gaussian", (Object)i);
                modelCovariances.set((Object)(j + i * annotationList.size()), "Annotation", (Object)annotationList.get(j));
                for (int k = 0; k < annotationList.size(); ++k) {
                    modelCovariances.set((Object)(j + i * annotationList.size()), annotationList.get(k), (Object)covMat.get(j, k));
                }
            }
        }
        return modelCovariances;
    }

    private void createVisualizationScript(List<VariantDatum> randomData, GaussianMixtureModel goodModel, GaussianMixtureModel badModel, double lodCutoff, String[] annotationKeys) {
        PrintStream stream;
        try {
            stream = new PrintStream(this.RSCRIPT_FILE);
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(this.RSCRIPT_FILE, (Exception)e);
        }
        stream.println("library(ggplot2)");
        stream.println("library(tools)");
        stream.println("library(grid)");
        this.createArrangeFunction(stream);
        stream.println("outputPDF <- \"" + this.RSCRIPT_FILE + ".pdf\"");
        stream.println("pdf(outputPDF)");
        for (int iii = 0; iii < annotationKeys.length; ++iii) {
            for (int jjj = iii + 1; jjj < annotationKeys.length; ++jjj) {
                this.logger.info("Building " + annotationKeys[iii] + " x " + annotationKeys[jjj] + " plot...");
                ArrayList<VariantDatum> fakeData = new ArrayList<VariantDatum>();
                double minAnn1 = 100.0;
                double maxAnn1 = -100.0;
                double minAnn2 = 100.0;
                double maxAnn2 = -100.0;
                for (VariantDatum datum : randomData) {
                    minAnn1 = Math.min(minAnn1, datum.annotations[iii]);
                    maxAnn1 = Math.max(maxAnn1, datum.annotations[iii]);
                    minAnn2 = Math.min(minAnn2, datum.annotations[jjj]);
                    maxAnn2 = Math.max(maxAnn2, datum.annotations[jjj]);
                }
                double NUM_STEPS = 60.0;
                for (double ann1 = minAnn1; ann1 <= maxAnn1; ann1 += (maxAnn1 - minAnn1) / 60.0) {
                    for (double ann2 = minAnn2; ann2 <= maxAnn2; ann2 += (maxAnn2 - minAnn2) / 60.0) {
                        VariantDatum datum = new VariantDatum();
                        datum.prior = 0.0;
                        datum.annotations = new double[randomData.get((int)0).annotations.length];
                        datum.isNull = new boolean[randomData.get((int)0).annotations.length];
                        for (int ann = 0; ann < datum.annotations.length; ++ann) {
                            datum.annotations[ann] = 0.0;
                            datum.isNull[ann] = true;
                        }
                        datum.annotations[iii] = ann1;
                        datum.annotations[jjj] = ann2;
                        datum.isNull[iii] = false;
                        datum.isNull[jjj] = false;
                        fakeData.add(datum);
                    }
                }
                this.engine.evaluateData(fakeData, goodModel, false);
                this.engine.evaluateData(fakeData, badModel, true);
                stream.print("surface <- c(");
                for (VariantDatum datum : fakeData) {
                    stream.print(String.format("%.4f, %.4f, %.4f, ", this.dataManager.denormalizeDatum(datum.annotations[iii], iii), this.dataManager.denormalizeDatum(datum.annotations[jjj], jjj), Math.min(4.0, Math.max(-4.0, datum.lod))));
                }
                stream.println("NA,NA,NA)");
                stream.println("s <- matrix(surface,ncol=3,byrow=T)");
                stream.print("data <- c(");
                for (VariantDatum datum : randomData) {
                    stream.print(String.format("%.4f, %.4f, %.4f, %d, %d,", this.dataManager.denormalizeDatum(datum.annotations[iii], iii), this.dataManager.denormalizeDatum(datum.annotations[jjj], jjj), datum.lod < lodCutoff ? -1.0 : 1.0, datum.atAntiTrainingSite ? -1 : (datum.atTrainingSite ? 1 : 0), datum.isKnown ? 1 : -1));
                }
                stream.println("NA,NA,NA,NA,1)");
                stream.println("d <- matrix(data,ncol=5,byrow=T)");
                String surfaceFrame = "sf." + annotationKeys[iii] + "." + annotationKeys[jjj];
                String dataFrame = "df." + annotationKeys[iii] + "." + annotationKeys[jjj];
                stream.println(surfaceFrame + " <- data.frame(x=s[,1], y=s[,2], lod=s[,3])");
                stream.println(dataFrame + " <- data.frame(x=d[,1], y=d[,2], retained=d[,3], training=d[,4], novelty=d[,5])");
                stream.println("dummyData <- " + dataFrame + "[1,]");
                stream.println("dummyData$x <- NaN");
                stream.println("dummyData$y <- NaN");
                stream.println("p <- ggplot(data=" + surfaceFrame + ", aes(x=x, y=y)) +theme(panel.background = element_rect(fill = \"white\"), panel.grid.minor = element_line(colour = \"white\"), panel.grid.major = element_line(colour = \"white\"))");
                stream.println("p1 = p +ggtitle(\"model PDF\") + labs(x=\"" + annotationKeys[iii] + "\", y=\"" + annotationKeys[jjj] + "\") + geom_tile(aes(fill = lod)) + scale_fill_gradient(high=\"green\", low=\"red\", space=\"rgb\")");
                stream.println("p <- qplot(x,y,data=" + dataFrame + ", color=retained, alpha=I(1/7),legend=FALSE) +theme(panel.background = element_rect(fill = \"white\"), panel.grid.minor = element_line(colour = \"white\"), panel.grid.major = element_line(colour = \"white\"))");
                stream.println("q <- geom_point(aes(x=x,y=y,color=retained),data=dummyData, alpha=1.0, na.rm=TRUE)");
                stream.println("p2 = p + q + labs(x=\"" + annotationKeys[iii] + "\", y=\"" + annotationKeys[jjj] + "\") + scale_colour_gradient(name=\"outcome\", high=\"black\", low=\"red\",breaks=c(-1,1),guide=\"legend\",labels=c(\"filtered\",\"retained\"))");
                stream.println("p <- qplot(x,y,data=" + dataFrame + "[" + dataFrame + "$training != 0,], color=training, alpha=I(1/7)) +theme(panel.background = element_rect(fill = \"white\"), panel.grid.minor = element_line(colour = \"white\"), panel.grid.major = element_line(colour = \"white\"))");
                stream.println("q <- geom_point(aes(x=x,y=y,color=training),data=dummyData, alpha=1.0, na.rm=TRUE)");
                stream.println("p3 = p + q + labs(x=\"" + annotationKeys[iii] + "\", y=\"" + annotationKeys[jjj] + "\") + scale_colour_gradient(high=\"green\", low=\"purple\",breaks=c(-1,1),guide=\"legend\", labels=c(\"neg\", \"pos\"))");
                stream.println("p <- qplot(x,y,data=" + dataFrame + ", color=novelty, alpha=I(1/7)) +theme(panel.background = element_rect(fill = \"white\"), panel.grid.minor = element_line(colour = \"white\"), panel.grid.major = element_line(colour = \"white\"))");
                stream.println("q <- geom_point(aes(x=x,y=y,color=novelty),data=dummyData, alpha=1.0, na.rm=TRUE)");
                stream.println("p4 = p + q + labs(x=\"" + annotationKeys[iii] + "\", y=\"" + annotationKeys[jjj] + "\") + scale_colour_gradient(name=\"novelty\", high=\"blue\", low=\"red\",breaks=c(-1,1),guide=\"legend\", labels=c(\"novel\",\"known\"))");
                stream.println("arrange(p1, p2, p3, p4, ncol=2)");
            }
        }
        stream.println("dev.off()");
        stream.println("if (exists(\"compactPDF\")) {");
        stream.println("compactPDF(outputPDF)");
        stream.println("}");
        stream.close();
        RScriptExecutor executor = new RScriptExecutor();
        executor.addScript(this.RSCRIPT_FILE);
        this.logger.info("Executing: " + executor.getApproximateCommandLine());
        executor.exec();
    }

    private void createArrangeFunction(PrintStream stream) {
        stream.println("vp.layout <- function(x, y) viewport(layout.pos.row=x, layout.pos.col=y)");
        stream.println("arrange <- function(..., nrow=NULL, ncol=NULL, as.table=FALSE) {");
        stream.println("dots <- list(...)");
        stream.println("n <- length(dots)");
        stream.println("if(is.null(nrow) & is.null(ncol)) { nrow = floor(n/2) ; ncol = ceiling(n/nrow)}");
        stream.println("if(is.null(nrow)) { nrow = ceiling(n/ncol)}");
        stream.println("if(is.null(ncol)) { ncol = ceiling(n/nrow)}");
        stream.println("grid.newpage()");
        stream.println("pushViewport(viewport(layout=grid.layout(nrow,ncol) ) )");
        stream.println("ii.p <- 1");
        stream.println("for(ii.row in seq(1, nrow)){");
        stream.println("ii.table.row <- ii.row ");
        stream.println("if(as.table) {ii.table.row <- nrow - ii.table.row + 1}");
        stream.println("for(ii.col in seq(1, ncol)){");
        stream.println("ii.table <- ii.p");
        stream.println("if(ii.p > n) break");
        stream.println("print(dots[[ii.table]], vp=vp.layout(ii.table.row, ii.col))");
        stream.println("ii.p <- ii.p + 1");
        stream.println("}");
        stream.println("}");
        stream.println("}");
    }
}

