/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;

final class VariantRecalibratorArgumentCollection {
    @Argument(fullName="mode", shortName="mode", doc="Recalibration mode to employ", optional=false)
    public Mode MODE = Mode.SNP;
    @Argument(fullName="use-allele-specific-annotations", shortName="AS", doc="If specified, the variant recalibrator will attempt to use the allele-specific versions of the specified annotations.", optional=true)
    public boolean useASannotations = false;
    @Advanced
    @Argument(fullName="max-gaussians", doc="Max number of Gaussians for the positive model", optional=true)
    public int MAX_GAUSSIANS = 8;
    @Advanced
    @Argument(fullName="max-negative-gaussians", doc="Max number of Gaussians for the negative model", optional=true)
    public int MAX_GAUSSIANS_FOR_NEGATIVE_MODEL = 2;
    @Advanced
    @Argument(fullName="max-iterations", doc="Maximum number of VBEM iterations", optional=true)
    public int MAX_ITERATIONS = 150;
    @Advanced
    @Argument(fullName="k-means-iterations", doc="Number of k-means iterations", optional=true)
    public int NUM_KMEANS_ITERATIONS = 100;
    @Advanced
    @Argument(fullName="standard-deviation-threshold", shortName="std", doc="Annotation value divergence threshold (number of standard deviations from the means) ", optional=true)
    public double STD_THRESHOLD = 10.0;
    @Advanced
    @Argument(fullName="shrinkage", doc="The shrinkage parameter in the variational Bayes algorithm.", optional=true)
    public double SHRINKAGE = 1.0;
    @Advanced
    @Argument(fullName="dirichlet", doc="The dirichlet parameter in the variational Bayes algorithm.", optional=true)
    public double DIRICHLET_PARAMETER = 0.001;
    @Advanced
    @Argument(fullName="prior-counts", doc="The number of prior counts to use in the variational Bayes algorithm.", optional=true)
    public double PRIOR_COUNTS = 20.0;
    @Advanced
    @Argument(fullName="maximum-training-variants", doc="Maximum number of training data", optional=true)
    protected int MAX_NUM_TRAINING_DATA = 2500000;
    @Advanced
    @Argument(fullName="minimum-bad-variants", doc="Minimum number of bad variants", optional=true)
    public int MIN_NUM_BAD_VARIANTS = 1000;
    @Advanced
    @Argument(fullName="bad-lod-score-cutoff", shortName="bad-lod-cutoff", doc="LOD score cutoff for selecting bad variants", optional=true)
    public double BAD_LOD_CUTOFF = -5.0;
    @Advanced
    @Argument(fullName="mq-cap-for-logit-jitter-transform", shortName="mq-cap", doc="Apply logit transform and jitter to MQ values", optional=true)
    public int MQ_CAP = 0;
    @Advanced
    @Argument(fullName="mq-jitter", doc="Amount of jitter (as a multiplier to a Normal(0,1) distribution) to add to the AS_MQ and transformed MQ values", optional=true)
    public double MQ_JITTER = 0.05;
    @Advanced
    @Argument(fullName="debug-stdev-thresholding", doc="Output variants that fail standard deviation thresholding to the log for debugging purposes. Redirection of stdout to a file is recommended.", optional=true)
    public boolean debugStdevThresholding = false;

    VariantRecalibratorArgumentCollection() {
    }

    public static enum Mode {
        SNP,
        INDEL,
        BOTH;

    }
}

