/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.vqsr;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.vqsr.GaussianMixtureModel;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantDatum;
import org.broadinstitute.hellbender.tools.walkers.vqsr.VariantRecalibratorArgumentCollection;
import org.broadinstitute.hellbender.utils.Utils;

public class VariantRecalibratorEngine {
    protected static final Logger logger = LogManager.getLogger(VariantRecalibratorEngine.class);
    public static final double MIN_ACCEPTABLE_LOD_SCORE = -20000.0;
    private final VariantRecalibratorArgumentCollection VRAC;
    private static final double MIN_PROB_CONVERGENCE = 0.002;

    public VariantRecalibratorEngine(VariantRecalibratorArgumentCollection VRAC) {
        this.VRAC = VRAC;
    }

    public GaussianMixtureModel generateModel(List<VariantDatum> data, int maxGaussians) {
        if (data == null || data.isEmpty()) {
            throw new UserException.VQSRNegativeModelFailure("No data found.");
        }
        if (maxGaussians <= 0) {
            throw new IllegalArgumentException("maxGaussians must be a positive integer but found: " + maxGaussians);
        }
        GaussianMixtureModel model = new GaussianMixtureModel(maxGaussians, data.size(), data.get((int)0).annotations.length, this.VRAC.SHRINKAGE, this.VRAC.DIRICHLET_PARAMETER, this.VRAC.PRIOR_COUNTS);
        this.variationalBayesExpectationMaximization(model, data);
        return model;
    }

    public void evaluateData(List<VariantDatum> data, GaussianMixtureModel model, boolean evaluateContrastively) {
        if (!model.isModelReadyForEvaluation) {
            try {
                model.precomputeDenominatorForEvaluation();
            }
            catch (Exception e) {
                logger.warn("Model could not pre-compute denominators. " + e.getMessage());
                model.failedToConverge = true;
                return;
            }
        }
        logger.info("Evaluating full set of " + data.size() + " variants...");
        for (VariantDatum datum : data) {
            double thisLod = this.evaluateDatum(datum, model);
            if (Double.isNaN(thisLod)) {
                model.failedToConverge = true;
                return;
            }
            datum.lod = evaluateContrastively ? (Double.isInfinite(datum.lod) ? -20000.0 + Utils.getRandomGenerator().nextDouble() * -20000.0 : datum.prior + datum.lod - thisLod) : thisLod;
        }
    }

    public void calculateWorstPerformingAnnotation(List<VariantDatum> data, GaussianMixtureModel goodModel, GaussianMixtureModel badModel) {
        for (VariantDatum datum : data) {
            int worstAnnotation = -1;
            double minProb = Double.MAX_VALUE;
            double worstValue = -1.0;
            for (int iii = 0; iii < datum.annotations.length; ++iii) {
                double prob;
                Double goodProbLog10 = goodModel.evaluateDatumInOneDimension(datum, iii);
                Double badProbLog10 = badModel.evaluateDatumInOneDimension(datum, iii);
                if (goodProbLog10 == null || badProbLog10 == null || !((prob = goodProbLog10 - badProbLog10) < minProb)) continue;
                minProb = prob;
                worstAnnotation = iii;
                worstValue = datum.annotations[iii];
            }
            datum.worstAnnotation = worstAnnotation;
            datum.worstValue = worstValue;
        }
    }

    private void variationalBayesExpectationMaximization(GaussianMixtureModel model, List<VariantDatum> data) {
        model.initializeRandomModel(data, this.VRAC.NUM_KMEANS_ITERATIONS);
        model.normalizePMixtureLog10();
        model.expectationStep(data);
        int iteration = 0;
        logger.info("Finished iteration " + iteration + ".");
        while (iteration < this.VRAC.MAX_ITERATIONS) {
            model.maximizationStep(data);
            double currentChangeInMixtureCoefficients = model.normalizePMixtureLog10();
            model.expectationStep(data);
            if (++iteration % 5 == 0) {
                logger.info("Finished iteration " + iteration + ". \tCurrent change in mixture coefficients = " + String.format("%.5f", currentChangeInMixtureCoefficients));
            }
            if (iteration <= 2 || !(currentChangeInMixtureCoefficients < 0.002)) continue;
            logger.info("Convergence after " + iteration + " iterations!");
            break;
        }
        model.evaluateFinalModelParameters(data);
    }

    private double evaluateDatum(VariantDatum datum, GaussianMixtureModel model) {
        return model.evaluateDatum(datum);
    }
}

