/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.transformers;

import htsjdk.samtools.util.SequenceUtil;
import java.util.List;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.clipping.ClippingOp;
import org.broadinstitute.hellbender.utils.clipping.ClippingRepresentation;
import org.broadinstitute.hellbender.utils.clipping.ReadClipper;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class AdapterTrimTransformer
implements ReadTransformer {
    private static final long serialVersionUID = 1L;
    private final int maxMismatches;
    private final int minClipLength;
    private final List<String> adapterSequences;

    public AdapterTrimTransformer(int maxMismatches, int minClipLength, List<String> adapterSequences) {
        this.maxMismatches = maxMismatches;
        this.minClipLength = minClipLength;
        this.adapterSequences = adapterSequences;
    }

    @Override
    public GATKRead apply(GATKRead read) {
        if (read.getLength() < this.minClipLength) {
            return read;
        }
        byte[] bases = read.getBases();
        int bestNumMismatches = this.maxMismatches;
        int bestAlignmentStart = bases.length;
        boolean foundAdapter = false;
        for (String adapterSequence : this.adapterSequences) {
            int alignmentLength = this.minClipLength;
            for (int alignmentStart = bases.length - this.minClipLength; alignmentStart >= 0; --alignmentStart) {
                int numMismatches = 0;
                for (int j = 0; j < alignmentLength && (SequenceUtil.isNoCall((byte)((byte)adapterSequence.charAt(j))) || bases[alignmentStart + j] == adapterSequence.charAt(j) || ++numMismatches <= this.maxMismatches); ++j) {
                }
                if (numMismatches < bestNumMismatches || numMismatches == bestNumMismatches && alignmentStart < bestAlignmentStart) {
                    bestNumMismatches = numMismatches;
                    bestAlignmentStart = alignmentStart;
                    foundAdapter = true;
                }
                alignmentLength = alignmentLength < adapterSequence.length() ? alignmentLength + 1 : alignmentLength;
            }
        }
        if (foundAdapter) {
            ReadClipper readClipper = new ReadClipper(read);
            readClipper.addOp(new ClippingOp(bestAlignmentStart, read.getLength()));
            return readClipper.clipRead(ClippingRepresentation.HARDCLIP_BASES);
        }
        return read;
    }
}

