/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.transformers;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.ApplyBQSRArgumentCollection;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.collections.NestedIntegerArray;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.recalibration.EventType;
import org.broadinstitute.hellbender.utils.recalibration.QuantizationInfo;
import org.broadinstitute.hellbender.utils.recalibration.RecalDatum;
import org.broadinstitute.hellbender.utils.recalibration.RecalUtils;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationReport;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationTables;
import org.broadinstitute.hellbender.utils.recalibration.covariates.CovariateKeyCache;
import org.broadinstitute.hellbender.utils.recalibration.covariates.ReadCovariates;
import org.broadinstitute.hellbender.utils.recalibration.covariates.StandardCovariateList;

public final class BQSRReadTransformer
implements ReadTransformer {
    private static final long serialVersionUID = 1L;
    private final QuantizationInfo quantizationInfo;
    private final RecalibrationTables recalibrationTables;
    private final StandardCovariateList covariates;
    private final SAMFileHeader header;
    private final int preserveQLessThan;
    private final double globalQScorePrior;
    private final boolean emitOriginalQuals;
    private final int totalCovariateCount;
    private final int specialCovariateCount;
    private static final int BASE_SUBSTITUTION_INDEX = EventType.BASE_SUBSTITUTION.ordinal();
    private final RecalDatum[] empiricalQualCovsArgs;
    private final boolean useOriginalBaseQualities;
    private byte[] staticQuantizedMapping;
    private final CovariateKeyCache keyCache;

    public BQSRReadTransformer(SAMFileHeader header, File bqsrRecalFile, ApplyBQSRArgumentCollection args) {
        this(header, new RecalibrationReport(bqsrRecalFile), args);
    }

    private BQSRReadTransformer(SAMFileHeader header, RecalibrationTables recalibrationTables, QuantizationInfo quantizationInfo, StandardCovariateList covariates, ApplyBQSRArgumentCollection args) {
        this.header = header;
        this.recalibrationTables = recalibrationTables;
        this.covariates = covariates;
        this.quantizationInfo = quantizationInfo;
        if (args.quantizationLevels == 0) {
            quantizationInfo.noQuantization();
        } else if (args.quantizationLevels > 0 && args.quantizationLevels != quantizationInfo.getQuantizationLevels()) {
            quantizationInfo.quantizeQualityScores(args.quantizationLevels);
        }
        this.preserveQLessThan = args.PRESERVE_QSCORES_LESS_THAN;
        this.globalQScorePrior = args.globalQScorePrior;
        this.emitOriginalQuals = args.emitOriginalQuals;
        this.useOriginalBaseQualities = args.useOriginalBaseQualities;
        if (args.staticQuantizationQuals != null && !args.staticQuantizationQuals.isEmpty()) {
            this.staticQuantizedMapping = BQSRReadTransformer.constructStaticQuantizedMapping(args.staticQuantizationQuals, args.roundDown);
        }
        this.totalCovariateCount = covariates.size();
        this.specialCovariateCount = covariates.numberOfSpecialCovariates();
        this.empiricalQualCovsArgs = new RecalDatum[this.totalCovariateCount - this.specialCovariateCount];
        this.keyCache = new CovariateKeyCache();
    }

    public BQSRReadTransformer(SAMFileHeader header, RecalibrationReport recalInfo, ApplyBQSRArgumentCollection args) {
        this(header, recalInfo.getRecalibrationTables(), recalInfo.getQuantizationInfo(), recalInfo.getCovariates(), args);
    }

    @Override
    public GATKRead apply(GATKRead originalRead) {
        GATKRead read;
        GATKRead gATKRead = read = this.useOriginalBaseQualities ? ReadUtils.resetOriginalBaseQualities(originalRead) : originalRead;
        if (this.emitOriginalQuals && !read.hasAttribute(SAMTag.OQ.name())) {
            try {
                read.setAttribute(SAMTag.OQ.name(), SAMUtils.phredToFastq((byte[])read.getBaseQualities()));
            }
            catch (IllegalArgumentException e) {
                throw new UserException.MalformedRead(read, "illegal base quality encountered; " + e.getMessage());
            }
        }
        ReadCovariates readCovariates = RecalUtils.computeCovariates(read, this.header, this.covariates, false, this.keyCache);
        read.clearAttribute("BI");
        read.clearAttribute("BD");
        int[][] fullReadKeySet = readCovariates.getKeySet(EventType.BASE_SUBSTITUTION);
        int rgKey = fullReadKeySet[0][0];
        RecalDatum empiricalQualRG = this.recalibrationTables.getReadGroupTable().get2Keys(rgKey, BASE_SUBSTITUTION_INDEX);
        if (empiricalQualRG == null) {
            return read;
        }
        byte[] quals = read.getBaseQualities();
        int readLength = quals.length;
        double epsilon = this.globalQScorePrior > 0.0 ? this.globalQScorePrior : empiricalQualRG.getEstimatedQReported();
        NestedIntegerArray<RecalDatum> qualityScoreTable = this.recalibrationTables.getQualityScoreTable();
        List<Byte> quantizedQuals = this.quantizationInfo.getQuantizedQuals();
        for (int offset = 0; offset < readLength; ++offset) {
            if (quals[offset] < this.preserveQLessThan) continue;
            Arrays.fill(this.empiricalQualCovsArgs, null);
            int[] keySet = fullReadKeySet[offset];
            RecalDatum empiricalQualQS = qualityScoreTable.get3Keys(keySet[0], keySet[1], BASE_SUBSTITUTION_INDEX);
            for (int i = this.specialCovariateCount; i < this.totalCovariateCount; ++i) {
                if (keySet[i] < 0) continue;
                this.empiricalQualCovsArgs[i - this.specialCovariateCount] = this.recalibrationTables.getTable(i).get4Keys(keySet[0], keySet[1], keySet[i], BASE_SUBSTITUTION_INDEX);
            }
            double recalibratedQualDouble = BQSRReadTransformer.hierarchicalBayesianQualityEstimate(epsilon, empiricalQualRG, empiricalQualQS, this.empiricalQualCovsArgs);
            byte recalibratedQualityScore = quantizedQuals.get(this.getRecalibratedQual(recalibratedQualDouble));
            quals[offset] = this.staticQuantizedMapping == null ? recalibratedQualityScore : this.staticQuantizedMapping[recalibratedQualityScore];
        }
        read.setBaseQualities(quals);
        return read;
    }

    private byte getRecalibratedQual(double recalibratedQualDouble) {
        return QualityUtils.boundQual(MathUtils.fastRound(recalibratedQualDouble), (byte)93);
    }

    public static double hierarchicalBayesianQualityEstimate(double epsilon, RecalDatum empiricalQualRG, RecalDatum empiricalQualQS, RecalDatum ... empiricalQualCovs) {
        double globalDeltaQ = empiricalQualRG == null ? 0.0 : empiricalQualRG.getEmpiricalQuality(epsilon) - epsilon;
        double deltaQReported = empiricalQualQS == null ? 0.0 : empiricalQualQS.getEmpiricalQuality(globalDeltaQ + epsilon) - (globalDeltaQ + epsilon);
        double deltaQCovariates = 0.0;
        double conditionalPrior2 = deltaQReported + globalDeltaQ + epsilon;
        for (RecalDatum empiricalQualCov : empiricalQualCovs) {
            if (empiricalQualCov == null) continue;
            deltaQCovariates += empiricalQualCov.getEmpiricalQuality(conditionalPrior2) - conditionalPrior2;
        }
        return conditionalPrior2 + deltaQCovariates;
    }

    public static byte[] constructStaticQuantizedMapping(List<Integer> staticQuantizedQuals, boolean roundDown) {
        if (staticQuantizedQuals == null || staticQuantizedQuals.isEmpty()) {
            return BQSRReadTransformer.createIdentityMatrix(254);
        }
        Utils.nonNull(staticQuantizedQuals);
        byte[] mapping = new byte[254];
        Collections.sort(staticQuantizedQuals);
        for (int i = 0; i < 6; ++i) {
            mapping[i] = (byte)i;
        }
        if (staticQuantizedQuals.size() == 1) {
            int onlyQual = staticQuantizedQuals.get(0);
            for (int i = 6; i < 254; ++i) {
                mapping[i] = (byte)onlyQual;
            }
            return mapping;
        }
        int firstQual = 6;
        int previousQual = 6;
        double previousProb = QualityUtils.qualToProb(previousQual);
        for (int nextQual : staticQuantizedQuals) {
            double nextProb = QualityUtils.qualToProb(nextQual);
            for (int i = previousQual; i < nextQual; ++i) {
                double iProb;
                mapping[i] = roundDown ? (byte)previousQual : ((iProb = QualityUtils.qualToProb(i)) - previousProb > nextProb - iProb ? (byte)nextQual : (byte)previousQual);
            }
            previousQual = nextQual;
            previousProb = nextProb;
        }
        for (int i = previousQual; i < 254; ++i) {
            mapping[i] = (byte)previousQual;
        }
        return mapping;
    }

    private static byte[] createIdentityMatrix(int maxQual) {
        byte[] bytes = new byte[maxQual];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)i;
        }
        return bytes;
    }
}

