/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.transformers;

import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.clipping.ClippingOp;
import org.broadinstitute.hellbender.utils.clipping.ClippingRepresentation;
import org.broadinstitute.hellbender.utils.clipping.ReadClipper;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class BaseQualityClipReadTransformer
implements ReadTransformer {
    private static final long serialVersionUID = 1L;
    private int qTrimmingThreshold = 15;

    public BaseQualityClipReadTransformer(int trim_thresh) {
        this.qTrimmingThreshold = trim_thresh;
    }

    @Override
    public GATKRead apply(GATKRead read) {
        GATKRead readClippedRightEnd = this.clipReadRightEnd(read);
        return this.clipReadLeftEnd(readClippedRightEnd);
    }

    public int getRightClipPoint(byte[] quals) {
        int clipSum = 0;
        int lastMax = -1;
        int clipPoint = -1;
        int readLength = quals.length;
        for (int i = readLength - 1; i >= 0; --i) {
            if ((clipSum += this.qTrimmingThreshold - quals[i]) < 0 || clipSum < lastMax) continue;
            lastMax = clipSum;
            clipPoint = i;
        }
        return clipPoint;
    }

    public int getLeftClipPoint(byte[] quals) {
        int clipSum = 0;
        int lastMax = -1;
        int clipPoint = -1;
        int readLength = quals.length;
        for (int i = 0; i < readLength; ++i) {
            if ((clipSum += this.qTrimmingThreshold - quals[i]) < 0 || clipSum < lastMax) continue;
            lastMax = clipSum;
            clipPoint = i;
        }
        return clipPoint;
    }

    private GATKRead clipReadRightEnd(GATKRead read) {
        byte[] quals = read.getBaseQualities();
        int clipPoint = this.getRightClipPoint(quals);
        if (clipPoint != -1) {
            ReadClipper readClipper = new ReadClipper(read);
            readClipper.addOp(new ClippingOp(clipPoint, read.getLength()));
            return readClipper.clipRead(ClippingRepresentation.HARDCLIP_BASES);
        }
        return read;
    }

    private GATKRead clipReadLeftEnd(GATKRead read) {
        byte[] quals = read.getBaseQualities();
        int clipPoint = this.getLeftClipPoint(quals);
        if (clipPoint != -1) {
            ReadClipper readClipper = new ReadClipper(read);
            readClipper.addOp(new ClippingOp(0, clipPoint));
            return readClipper.clipRead(ClippingRepresentation.HARDCLIP_BASES);
        }
        return read;
    }
}

