/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.transformers;

import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class BaseQualityReadTransformer
implements ReadTransformer {
    private static final long serialVersionUID = 1L;
    private int BASE_QUALITY_THRESHOLD = 15;

    public BaseQualityReadTransformer() {
    }

    public BaseQualityReadTransformer(int quality_threshold) {
        this.BASE_QUALITY_THRESHOLD = quality_threshold;
    }

    @Override
    public GATKRead apply(GATKRead read) {
        if (read.getBaseQualityCount() == read.getLength()) {
            byte[] bases_new = read.getBases();
            for (int i = 0; i < read.getLength(); ++i) {
                if (read.getBaseQuality(i) >= this.BASE_QUALITY_THRESHOLD) continue;
                bases_new[i] = 78;
            }
            read.setBases(bases_new);
        }
        return read;
    }
}

