/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.transformers;

import com.google.common.annotations.VisibleForTesting;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class DRAGENMappingQualityReadTransformer
implements ReadTransformer {
    private static final long serialVersionUID = 1L;
    public static String EXTENDED_MAPPING_QUALITY_READ_TAG = "XQ";
    private static final int[] mQTableX = new int[]{0, 30, 60, 100, 200, 256};
    private static final int[] mQTableY = new int[]{0, 30, 40, 45, 50, 50};

    @VisibleForTesting
    public static double mapMappingQualityToPhredLikelihoodScore(int val) {
        for (int i = 1; i < mQTableX.length; ++i) {
            if (val > mQTableX[i]) continue;
            double xfactor = 1.0 * (double)(val - mQTableX[i - 1]) / (double)(mQTableX[i] - mQTableX[i - 1]);
            return (double)mQTableY[i - 1] + xfactor * (double)(mQTableY[i] - mQTableY[i - 1]);
        }
        throw new GATKException("Something went wrong trying to map an an invalid XQ tag '" + val + "' val must fall between 0 and 250");
    }

    @Override
    public GATKRead apply(GATKRead read) {
        if (read.hasAttribute(EXTENDED_MAPPING_QUALITY_READ_TAG)) {
            int extendedMQ = read.getAttributeAsInteger(EXTENDED_MAPPING_QUALITY_READ_TAG);
            read.setMappingQuality(extendedMQ);
        }
        return read;
    }
}

