/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import scala.Tuple2;

public class DUSTReadTransformer
implements ReadTransformer {
    public static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(DUSTReadTransformer.class);
    private int MASK_PHRED = 15;
    private int W = 64;
    private double T = 20.0;

    public DUSTReadTransformer(int dust_mask, int dust_w, double dust_t) {
        this.MASK_PHRED = dust_mask;
        this.W = dust_w;
        this.T = dust_t;
    }

    @Override
    public GATKRead apply(GATKRead read) {
        List<IntTuple> res = DUSTReadTransformer.runDUST(read, this.W, this.T);
        byte[] q_new = read.getBases();
        for (IntTuple interval : res) {
            for (int i = interval.a; i <= interval.b; ++i) {
                q_new[i] = 78;
            }
        }
        read.setBases(q_new);
        if (read.getBaseQualityCount() == read.getLength()) {
            byte[] qual_new = read.getBaseQualities();
            for (IntTuple interval : res) {
                for (int i = interval.a; i <= interval.b; ++i) {
                    qual_new[i] = (byte)this.MASK_PHRED;
                }
            }
            read.setBaseQualities(qual_new);
        }
        return read;
    }

    public static Collection<Tuple2<Integer, Integer>> sDUST(GATKRead read, int window, double tscore) {
        List<IntTuple> res = DUSTReadTransformer.runDUST(read, window, tscore);
        ArrayList<Tuple2<Integer, Integer>> res_tuple2 = new ArrayList<Tuple2<Integer, Integer>>(res.size());
        for (IntTuple tuple : res) {
            res_tuple2.add((Tuple2<Integer, Integer>)new Tuple2((Object)tuple.a, (Object)tuple.b));
        }
        return res_tuple2;
    }

    private static List<IntTuple> runDUST(GATKRead read, int window, double tscore) {
        int wstart;
        byte[] q = read.getBases();
        Random rng = null;
        for (int i = 0; i < q.length; ++i) {
            if (q[i] == 78 || q[i] == 110) {
                if (rng == null) {
                    rng = new Random();
                    rng.setSeed(0L);
                }
                q[i] = (byte)rng.nextInt(4);
                continue;
            }
            if (q[i] == 65 || q[i] == 97) {
                q[i] = 0;
                continue;
            }
            if (q[i] == 84 || q[i] == 116) {
                q[i] = 1;
                continue;
            }
            if (q[i] == 67 || q[i] == 99) {
                q[i] = 2;
                continue;
            }
            if (q[i] == 71 || q[i] == 103) {
                q[i] = 3;
                continue;
            }
            logger.warn("Invalid base " + (char)q[i] + " in read " + read.getName() + ", assigning to random base.");
            if (rng == null) {
                rng = new Random();
                rng.setSeed(0L);
            }
            q[i] = (byte)rng.nextInt(4);
        }
        ArrayList<IntTuple> final_intervals = new ArrayList<IntTuple>();
        LinkedList<PStruct> perfect_intervals = new LinkedList<PStruct>();
        short[] triplet_count_suffix = new short[64];
        short[] triplet_count_window = new short[64];
        int running_score_suffix = 0;
        int running_score_window = 0;
        LinkedList<Integer> window_triplets = new LinkedList<Integer>();
        int L = 0;
        for (int wfinish = 2; wfinish < read.getLength(); ++wfinish) {
            int s;
            wstart = Math.max(wfinish - window + 1, 0);
            DUSTReadTransformer.save_masked_regions(perfect_intervals, final_intervals, wstart);
            int t = DUSTReadTransformer.triplet(q[wfinish - 2], q[wfinish - 1], q[wfinish]);
            if (window_triplets.size() >= window - 2) {
                int n = s = ((Integer)window_triplets.pop()).intValue();
                short s2 = (short)(triplet_count_window[n] - 1);
                triplet_count_window[n] = s2;
                running_score_window -= s2;
                if (L > window_triplets.size()) {
                    --L;
                    int n2 = s;
                    short s3 = (short)(triplet_count_suffix[n2] - 1);
                    triplet_count_suffix[n2] = s3;
                    running_score_suffix -= s3;
                }
            }
            window_triplets.add(t);
            ++L;
            int n = t;
            short s4 = triplet_count_window[n];
            triplet_count_window[n] = (short)(s4 + 1);
            running_score_window += s4;
            int n3 = t;
            short s5 = triplet_count_suffix[n3];
            triplet_count_suffix[n3] = (short)(s5 + 1);
            running_score_suffix += s5;
            if ((double)(triplet_count_suffix[t] * 10) > 2.0 * tscore) {
                do {
                    int n4 = s = ((Integer)window_triplets.get(window_triplets.size() - L)).intValue();
                    short s6 = (short)(triplet_count_suffix[n4] - 1);
                    triplet_count_suffix[n4] = s6;
                    running_score_suffix -= s6;
                    --L;
                } while (s != t);
            }
            if (!((double)(running_score_window * 10) > (double)L * tscore)) continue;
            short[] c = (short[])triplet_count_suffix.clone();
            int r = running_score_suffix;
            ListIterator<PStruct> iter = perfect_intervals.listIterator();
            PStruct perf = iter.hasNext() ? (PStruct)iter.next() : null;
            double max_score = 0.0;
            for (int i = window_triplets.size() - L - 1; i >= 0; --i) {
                t = (Integer)window_triplets.get(i);
                r += c[t];
                int n5 = t;
                c[n5] = (short)(c[n5] + 1);
                double new_score = (double)r / (double)(window_triplets.size() - i - 1);
                if (!(new_score * 10.0 > tscore)) continue;
                while (perf != null && perf.start >= i + wstart) {
                    max_score = Math.max(max_score, perf.score);
                    perf = iter.hasNext() ? (PStruct)iter.next() : null;
                }
                if (!(new_score >= max_score)) continue;
                max_score = new_score;
                PStruct new_perf = new PStruct();
                new_perf.start = i + wstart;
                new_perf.finish = window_triplets.size() + 1 + wstart;
                new_perf.score = new_score;
                if (iter.hasPrevious()) {
                    iter.previous();
                } else {
                    iter = perfect_intervals.listIterator();
                }
                iter.add(new_perf);
                if (!iter.hasNext()) continue;
                iter.next();
            }
        }
        wstart = Math.max(0, read.getLength() - window + 1);
        while (!perfect_intervals.isEmpty()) {
            DUSTReadTransformer.save_masked_regions(perfect_intervals, final_intervals, wstart);
            ++wstart;
        }
        return final_intervals;
    }

    private static void save_masked_regions(LinkedList<PStruct> perfect_intervals, ArrayList<IntTuple> final_intervals, int wstart) {
        if (!perfect_intervals.isEmpty()) {
            PStruct p1 = perfect_intervals.getLast();
            if (p1.start < wstart) {
                int l = final_intervals.size();
                if (l > 0) {
                    IntTuple rt = final_intervals.get(l - 1);
                    if (p1.start < rt.b + 1) {
                        IntTuple new_rt = new IntTuple(rt.a, Math.max(rt.b, p1.finish));
                        final_intervals.set(l - 1, new_rt);
                    } else {
                        final_intervals.add(new IntTuple(p1.start, p1.finish));
                    }
                } else {
                    final_intervals.add(new IntTuple(p1.start, p1.finish));
                }
                while (p1 != null && p1.start < wstart) {
                    perfect_intervals.removeLast();
                    p1 = perfect_intervals.isEmpty() ? null : perfect_intervals.getLast();
                }
            }
        }
    }

    private static int triplet(byte b1, byte b2, byte b3) {
        return b1 | b2 << 2 | b3 << 4;
    }

    private static final class IntTuple {
        public int a;
        public int b;

        public IntTuple(int a, int b) {
            this.a = a;
            this.b = b;
        }
    }

    private static final class PStruct {
        public int start = 0;
        public int finish = 0;
        public double score = 0.0;

        private PStruct() {
        }
    }
}

