/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.transformers;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class IUPACReadTransformer
implements ReadTransformer {
    private static final long serialVersionUID = 1L;
    private boolean strictMode;
    private OneShotLogger logger = new OneShotLogger(this.getClass());

    public IUPACReadTransformer() {
        this.strictMode = false;
    }

    public IUPACReadTransformer(boolean strictMode) {
        this.strictMode = strictMode;
    }

    @Override
    public GATKRead apply(GATKRead read) {
        byte[] maybeTransformed = BaseUtils.convertIUPACtoN(read.getBases(), this.strictMode, false);
        if (!Arrays.equals(read.getBases(), maybeTransformed)) {
            this.logger.warn(() -> "At least one read contains IUPAC bases that have been transformed.  Read " + read.getName() + " contains: " + IntStream.range(0, read.getBases().length).map(idx -> read.getBase(idx)).filter(i -> !BaseUtils.isNucleotide((byte)i) && !BaseUtils.isNBase((byte)i)).mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toList()));
            read.setBases(maybeTransformed);
        }
        return read;
    }
}

