/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.transformers;

import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class MisencodedBaseQualityReadTransformer
implements ReadTransformer {
    private static final long serialVersionUID = 1L;
    private static final int ILLUMINA_ENCODING_FIX_VALUE = 31;

    @Override
    public GATKRead apply(GATKRead read) {
        byte[] quals = read.getBaseQualities();
        for (int i = 0; i < quals.length; ++i) {
            int n = i;
            quals[n] = (byte)(quals[n] - 31);
            if (quals[i] >= 0) continue;
            throw new UserException.BadInput("while fixing mis-encoded base qualities we encountered a read that was correctly encoded; we cannot handle such a mixture of reads so unfortunately the BAM must be fixed with some other tool");
        }
        read.setBaseQualities(quals);
        return read;
    }
}

