/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.transformers;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class NDNCigarReadTransformer
implements ReadTransformer {
    private static final long serialVersionUID = 1L;

    @Override
    public GATKRead apply(GATKRead read) {
        Cigar originalCigar = read.getCigar();
        Utils.validateArg(originalCigar.isValid(read.getName(), -1L) == null, () -> "try to transform a read with non-valid cigar string: readName: " + read.getName() + " Cigar String: " + originalCigar);
        read.setCigar(NDNCigarReadTransformer.refactorNDNtoN(originalCigar));
        return read;
    }

    @VisibleForTesting
    protected static Cigar refactorNDNtoN(Cigar originalCigar) {
        Cigar refactoredCigar = new Cigar();
        int cigarLength = originalCigar.numCigarElements();
        for (int i = 0; i < cigarLength; ++i) {
            CigarElement element = originalCigar.getCigarElement(i);
            if (element.getOperator() == CigarOperator.N && NDNCigarReadTransformer.thereAreAtLeast2MoreElements(i, cigarLength)) {
                CigarElement nextElement = originalCigar.getCigarElement(i + 1);
                CigarElement nextNextElement = originalCigar.getCigarElement(i + 2);
                if (nextElement.getOperator() == CigarOperator.D && nextNextElement.getOperator() == CigarOperator.N) {
                    int threeElementsLength = element.getLength() + nextElement.getLength() + nextNextElement.getLength();
                    CigarElement refactoredElement = new CigarElement(threeElementsLength, CigarOperator.N);
                    refactoredCigar.add(refactoredElement);
                    i += 2;
                    continue;
                }
                refactoredCigar.add(element);
                continue;
            }
            refactoredCigar.add(element);
        }
        return refactoredCigar;
    }

    private static boolean thereAreAtLeast2MoreElements(int index, int cigarLength) {
        return index < cigarLength - 2;
    }
}

