/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.transformers;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMSequenceDictionary;
import org.apache.commons.lang3.mutable.MutableInt;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.clipping.ClippingOp;
import org.broadinstitute.hellbender.utils.clipping.ClippingRepresentation;
import org.broadinstitute.hellbender.utils.clipping.ReadClipper;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public final class PalindromeArtifactClipReadTransformer
implements ReadTransformer {
    private static final long serialVersionUID = 1L;
    public static final double MIN_FRACTION_OF_MATCHING_BASES = 0.9;
    private final ReferenceDataSource referenceDataSource;
    private final SAMSequenceDictionary sequenceDictionary;
    private final int minPalindromeSize;

    public PalindromeArtifactClipReadTransformer(ReferenceDataSource referenceDataSource, int minPalindromeSize) {
        this.referenceDataSource = referenceDataSource;
        this.minPalindromeSize = minPalindromeSize;
        this.sequenceDictionary = referenceDataSource.getSequenceDictionary();
    }

    @Override
    public GATKRead apply(GATKRead read) {
        int refEnd;
        boolean readIsUpstreamOfMate;
        int adaptorBoundary = read.getAdaptorBoundary();
        if (!read.isProperlyPaired() || adaptorBoundary == ReadUtils.CANNOT_COMPUTE_ADAPTOR_BOUNDARY) {
            return read;
        }
        Cigar cigar = read.getCigar();
        CigarOperator firstOperator = cigar.getFirstCigarElement().getOperator();
        CigarOperator lastOperator = cigar.getLastCigarElement().getOperator();
        boolean bl = readIsUpstreamOfMate = read.getFragmentLength() > 0;
        if (readIsUpstreamOfMate && firstOperator != CigarOperator.SOFT_CLIP && firstOperator != CigarOperator.INSERTION || !readIsUpstreamOfMate && lastOperator != CigarOperator.SOFT_CLIP && lastOperator != CigarOperator.INSERTION) {
            return read;
        }
        int potentialArtifactBaseCount = readIsUpstreamOfMate ? cigar.getFirstCigarElement().getLength() : cigar.getLastCigarElement().getLength();
        int numBasesToCompare = Math.min(potentialArtifactBaseCount + this.minPalindromeSize, read.getLength());
        String contig = read.getContig();
        int refStart = readIsUpstreamOfMate ? adaptorBoundary - numBasesToCompare : adaptorBoundary + 1;
        int n = refEnd = readIsUpstreamOfMate ? adaptorBoundary - 1 : adaptorBoundary + numBasesToCompare;
        if (refStart < 1 || refEnd > this.sequenceDictionary.getSequence(contig).getSequenceLength()) {
            return read;
        }
        if (readIsUpstreamOfMate && refStart < read.getStart() || !readIsUpstreamOfMate && read.getEnd() < refEnd) {
            return read;
        }
        SimpleInterval refInterval = new SimpleInterval(contig, refStart, refEnd);
        MutableInt numMatch = new MutableInt(0);
        MutableInt readIndex = new MutableInt(readIsUpstreamOfMate ? numBasesToCompare - 1 : read.getLength() - 1);
        this.referenceDataSource.query(refInterval).forEachRemaining(refBase -> {
            if (BaseUtils.getComplement(refBase) == read.getBase(readIndex.getValue())) {
                numMatch.increment();
            }
            readIndex.decrement();
        });
        if (numMatch.doubleValue() / (double)numBasesToCompare >= 0.9) {
            ReadClipper readClipper = new ReadClipper(read);
            ClippingOp clippingOp = readIsUpstreamOfMate ? new ClippingOp(0, potentialArtifactBaseCount - 1) : new ClippingOp(read.getLength() - potentialArtifactBaseCount, read.getLength());
            readClipper.addOp(clippingOp);
            return readClipper.clipRead(ClippingRepresentation.HARDCLIP_BASES);
        }
        return read;
    }
}

