/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.transformers;

import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.clipping.ClippingOp;
import org.broadinstitute.hellbender.utils.clipping.ClippingRepresentation;
import org.broadinstitute.hellbender.utils.clipping.ReadClipper;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class SimpleRepeatMaskTransformer
implements ReadTransformer {
    private static final long serialVersionUID = 1L;
    private final int windowSize;
    private final int threshAT;
    private final int threshGC;

    public SimpleRepeatMaskTransformer(int threshAT, int threshGC, int windowSize) {
        Utils.validateArg(threshAT <= windowSize, "SimpleRepeatMaskTransformer threshold AT greater than window size.");
        Utils.validateArg(threshGC <= windowSize, "SimpleRepeatMaskTransformer threshold GC greater than window size.");
        this.threshAT = threshAT;
        this.threshGC = threshGC;
        this.windowSize = windowSize;
    }

    @Override
    public GATKRead apply(GATKRead read) {
        byte[] originalBases = (byte[])read.getBases().clone();
        byte[] baseCounts = new byte[255];
        int windowStart = 0;
        int windowEnd = Math.min(this.windowSize, originalBases.length);
        for (int i = windowStart; i < windowEnd; ++i) {
            byte by = originalBases[i];
            baseCounts[by] = (byte)(baseCounts[by] + 1);
        }
        int maskStart = 0;
        int maskEnd = 0;
        if (this.isSimpleRepeat(baseCounts)) {
            maskEnd = windowEnd;
        }
        while (windowEnd < originalBases.length) {
            byte by = originalBases[windowStart++];
            baseCounts[by] = (byte)(baseCounts[by] - 1);
            byte by2 = originalBases[windowEnd++];
            baseCounts[by2] = (byte)(baseCounts[by2] + 1);
            if (!this.isSimpleRepeat(baseCounts)) continue;
            if (windowEnd == maskEnd + 1) {
                ++maskEnd;
                continue;
            }
            read = this.maskRead(read, maskStart, maskEnd);
            maskStart = windowStart;
            maskEnd = windowEnd;
        }
        read = this.maskRead(read, maskStart, maskEnd);
        return read;
    }

    private boolean isSimpleRepeat(byte[] baseCounts) {
        int countN = baseCounts[78] + baseCounts[110];
        int countATN = baseCounts[65] + baseCounts[97] + baseCounts[84] + baseCounts[116] + countN;
        int countGCN = baseCounts[71] + baseCounts[103] + baseCounts[67] + baseCounts[99] + countN;
        return countATN >= this.threshAT || countGCN >= this.threshGC;
    }

    private GATKRead maskRead(GATKRead read, int maskStart, int maskEnd) {
        ReadClipper readClipper = new ReadClipper(read);
        readClipper.addOp(new ClippingOp(maskStart, maskEnd - 1));
        return readClipper.clipRead(ClippingRepresentation.WRITE_NS_Q0S);
    }
}

