/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.util.function.Consumer;
import org.broadinstitute.hellbender.utils.Utils;

public abstract class AutoCloseableReference<T>
implements AutoCloseable {
    private T subject;

    public static <T> AutoCloseableReference<T> of(T subject, final Consumer<T> closeAction) {
        Utils.nonNull(closeAction);
        return new AutoCloseableReference<T>(subject){

            @Override
            protected void close(T subject) {
                closeAction.accept(subject);
            }
        };
    }

    protected AutoCloseableReference(T subject) {
        this.subject = Utils.nonNull(subject);
    }

    public final T get() {
        if (this.subject == null) {
            throw new IllegalStateException("reference already closed");
        }
        return this.subject;
    }

    @Override
    public final void close() {
        T subject = this.subject;
        if (subject != null) {
            this.subject = null;
            this.close(subject);
        }
    }

    public final boolean isClosed() {
        return this.subject == null;
    }

    protected abstract void close(T var1);
}

