/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.Utils;

public final class BaseUtils {
    public static final byte[] BASES = new byte[]{65, 67, 71, 84};
    public static final char[] BASE_CHARS = new char[]{'A', 'C', 'G', 'T'};
    public static final byte[] BASES_EXTENDED = new byte[]{65, 67, 71, 84, 78, 68};
    public static final char[] BASE_CHARS_EXTENDED = new char[]{'A', 'C', 'G', 'T', 'N', 'D'};
    private static final int[] baseIndexMap = new int[256];
    private static final int[] baseIndexWithIupacMap;
    public static final Comparator<byte[]> BASES_COMPARATOR;

    public static boolean isNBase(byte base) {
        return base == 78 || base == 110;
    }

    public static BaseSubstitutionType SNPSubstitutionType(byte base1, byte base2) {
        BaseSubstitutionType t = BaseUtils.isTransition(base1, base2) ? BaseSubstitutionType.TRANSITION : BaseSubstitutionType.TRANSVERSION;
        return t;
    }

    public static boolean isTransition(byte base1, byte base2) {
        int b1 = BaseUtils.simpleBaseToBaseIndex(base1);
        int b2 = BaseUtils.simpleBaseToBaseIndex(base2);
        return b1 == Base.A.ordinal() && b2 == Base.G.ordinal() || b1 == Base.G.ordinal() && b2 == Base.A.ordinal() || b1 == Base.C.ordinal() && b2 == Base.T.ordinal() || b1 == Base.T.ordinal() && b2 == Base.C.ordinal();
    }

    private BaseUtils() {
    }

    public static boolean basesAreEqual(byte base1, byte base2) {
        return BaseUtils.simpleBaseToBaseIndex(base1) == BaseUtils.simpleBaseToBaseIndex(base2);
    }

    public static byte[] convertIUPACtoN(byte[] bases, boolean errorOnBadReferenceBase, boolean ignoreConversionOfFirstByte) {
        int start;
        int length = bases.length;
        for (int i = start = ignoreConversionOfFirstByte ? 1 : 0; i < length; ++i) {
            int unsignedBase = bases[i] & 0xFF;
            int baseIndex = baseIndexWithIupacMap[unsignedBase];
            if (baseIndex == Base.N.ordinal()) {
                bases[i] = 78;
                continue;
            }
            if (!errorOnBadReferenceBase || baseIndex != -1) continue;
            throw new UserException.BadInput("We encountered a non-standard non-IUPAC base in the provided input sequence: '" + bases[i] + "'");
        }
        return bases;
    }

    public static int simpleBaseToBaseIndex(byte base) {
        int unsignedBase = base & 0xFF;
        return baseIndexMap[unsignedBase];
    }

    public static int extendedBaseToBaseIndex(byte base) {
        switch (base) {
            case 68: 
            case 100: {
                return Base.D.ordinal();
            }
            case 78: 
            case 110: {
                return Base.N.ordinal();
            }
        }
        return BaseUtils.simpleBaseToBaseIndex(base);
    }

    public static boolean isRegularBase(byte base) {
        return BaseUtils.simpleBaseToBaseIndex(base) != -1;
    }

    public static boolean isNucleotide(byte base) {
        return base != 42 && BaseUtils.simpleBaseToBaseIndex(base) != -1;
    }

    public static boolean isAllRegularBases(byte[] bases) {
        for (byte base : bases) {
            if (BaseUtils.isRegularBase(base)) continue;
            return false;
        }
        return true;
    }

    public static byte baseIndexToSimpleBase(int baseIndex) {
        switch (baseIndex) {
            case 0: {
                return 65;
            }
            case 1: {
                return 67;
            }
            case 2: {
                return 71;
            }
            case 3: {
                return 84;
            }
        }
        return 46;
    }

    public static byte simpleComplement(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 84;
            }
            case 67: 
            case 99: {
                return 71;
            }
            case 71: 
            case 103: {
                return 67;
            }
            case 84: 
            case 116: {
                return 65;
            }
        }
        return base;
    }

    public static byte[] simpleReverseComplement(byte[] bases) {
        byte[] rcbases = new byte[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            rcbases[i] = BaseUtils.simpleComplement(bases[bases.length - 1 - i]);
        }
        return rcbases;
    }

    public static void fillWithRandomBases(byte[] dest, int fromIndex, int toIndex) {
        Random rnd = Utils.getRandomGenerator();
        Utils.nonNull(dest, "the dest array cannot be null");
        Utils.validateArg(fromIndex <= toIndex, "fromIndex cannot be larger than toIndex");
        Utils.validateArg(fromIndex >= 0, "both indexes must be positive");
        Utils.validateArg(toIndex <= dest.length, "both indexes must be less or equal to the destination array length");
        new IndexRange(fromIndex, toIndex).forEach(i -> {
            dest[i] = BaseUtils.baseIndexToSimpleBase(rnd.nextInt(4));
        });
    }

    public static byte getComplement(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 84;
            }
            case 67: 
            case 99: {
                return 71;
            }
            case 71: 
            case 103: {
                return 67;
            }
            case 84: 
            case 116: {
                return 65;
            }
            case 78: 
            case 110: {
                return 78;
            }
        }
        throw new IllegalArgumentException("base must be A, C, G or T. " + (char)base + " is not a valid base.");
    }

    public static byte basesToIUPAC(byte base1, byte base2) {
        if (base2 < base1) {
            return BaseUtils.basesToIUPAC(base2, base1);
        }
        if (!BaseUtils.isRegularBase(base1) || !BaseUtils.isRegularBase(base2)) {
            return Base.N.base;
        }
        if (BaseUtils.basesAreEqual(base1, base2)) {
            return base1;
        }
        if (base1 == Base.A.base) {
            return (byte)(base2 == Base.C.base ? 77 : (base2 == Base.G.base ? 82 : 87));
        }
        if (base1 == Base.C.base) {
            return (byte)(base2 == Base.G.base ? 83 : 89);
        }
        return 75;
    }

    static {
        Arrays.fill(baseIndexMap, -1);
        BaseUtils.baseIndexMap[65] = Base.A.ordinal();
        BaseUtils.baseIndexMap[97] = Base.A.ordinal();
        BaseUtils.baseIndexMap[42] = Base.A.ordinal();
        BaseUtils.baseIndexMap[67] = Base.C.ordinal();
        BaseUtils.baseIndexMap[99] = Base.C.ordinal();
        BaseUtils.baseIndexMap[71] = Base.G.ordinal();
        BaseUtils.baseIndexMap[103] = Base.G.ordinal();
        BaseUtils.baseIndexMap[84] = Base.T.ordinal();
        BaseUtils.baseIndexMap[116] = Base.T.ordinal();
        baseIndexWithIupacMap = Arrays.copyOf(baseIndexMap, baseIndexMap.length);
        BaseUtils.baseIndexWithIupacMap[42] = -1;
        BaseUtils.baseIndexWithIupacMap[78] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[110] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[82] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[114] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[89] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[121] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[77] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[109] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[75] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[107] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[87] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[119] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[83] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[115] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[66] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[98] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[68] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[100] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[72] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[104] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[86] = Base.N.ordinal();
        BaseUtils.baseIndexWithIupacMap[118] = Base.N.ordinal();
        BASES_COMPARATOR = (o1, o2) -> {
            Utils.nonNull(o1, "o1");
            Utils.nonNull(o2, "o2");
            int minLength = Math.min(((byte[])o1).length, ((byte[])o2).length);
            for (int i = 0; i < minLength; ++i) {
                int cmp = Byte.compare(o1[i], o2[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(((byte[])o1).length, ((byte[])o2).length);
        };
    }

    public static enum BaseSubstitutionType {
        TRANSITION,
        TRANSVERSION;

    }

    public static enum Base {
        A('A'),
        C('C'),
        G('G'),
        T('T'),
        N('N'),
        D('D');

        public byte base;

        private Base(char base) {
            this.base = (byte)base;
        }
    }
}

