/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.input.NullInputStream;
import org.broadinstitute.hellbender.exceptions.UserException;

public abstract class BinaryTableReader<R>
implements AutoCloseable,
Iterator<R> {
    private final DataInput dtInput;
    private R next;
    private final Runnable closeAction;

    protected BinaryTableReader(InputStream in, String source) {
        DataInputStream dataInputStream = new DataInputStream(in);
        this.dtInput = new DataInputStream(in);
        this.closeAction = () -> {
            try {
                dataInputStream.close();
            }
            catch (IOException ex) {
                throw source != null ? new UserException.CouldNotReadInputFile(source) : new UserException.CouldNotReadInputFile("unknown source");
            }
        };
        this.next = this.readNextRecord();
    }

    public static <E> BinaryTableReader<E> emptyReader() {
        return new BinaryTableReader<E>((InputStream)new NullInputStream(0L), "null"){

            @Override
            protected E readRecord(DataInput input) throws EOFException {
                throw new EOFException("reached the end");
            }
        };
    }

    private R readNextRecord() {
        try {
            return this.readRecord(this.dtInput);
        }
        catch (EOFException ex) {
            return null;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected abstract R readRecord(DataInput var1) throws IOException;

    public final Stream<R> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return BinaryTableReader.this.next != null;
            }

            @Override
            public R next() {
                Object result = BinaryTableReader.this.next;
                BinaryTableReader.this.next = BinaryTableReader.this.readNextRecord();
                return result;
            }
        }, 0), false);
    }

    @Override
    public final void close() throws IOException {
        try {
            this.closeAction.run();
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw ex;
        }
    }

    public final List<R> readAll() {
        return this.stream().collect(Collectors.toList());
    }

    @Override
    public final boolean hasNext() {
        return this.next != null;
    }

    @Override
    public final R next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        R result = this.next;
        this.next = this.readNextRecord();
        return result;
    }
}

