/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public abstract class BinaryTableWriter<R>
implements AutoCloseable {
    protected final DataOutputStream dataOut;
    private final ByteCounterOutputStream byteCounter;
    private String path;
    private long counter;

    protected BinaryTableWriter(OutputStream out, String path) {
        Utils.nonNull(out);
        this.byteCounter = new ByteCounterOutputStream(out);
        this.dataOut = new DataOutputStream(this.byteCounter);
        this.path = path;
    }

    public long offset() {
        return this.byteCounter.count();
    }

    public String getPath() {
        return this.path;
    }

    protected abstract void writeRecord(R var1, DataOutput var2) throws IOException;

    public void write(R record) throws IOException {
        this.writeRecord(Utils.nonNull(record), this.dataOut);
        ++this.counter;
    }

    public void writeAll(Iterable<? extends R> records) throws IOException {
        for (R record : Utils.nonNull(records)) {
            this.writeRecord(Utils.nonNull(record), this.dataOut);
            ++this.counter;
        }
    }

    @Override
    public void close() throws IOException {
        this.dataOut.close();
    }

    public void flush() throws IOException {
        this.dataOut.flush();
    }

    public long numberOfRecords() {
        return this.counter;
    }

    private static class ByteCounterOutputStream
    extends OutputStream {
        private final OutputStream out;
        private long count;

        long count() {
            return this.count;
        }

        private ByteCounterOutputStream(OutputStream out) {
            this.out = Utils.nonNull(out);
            this.count = 0L;
        }

        @Override
        public void write(int b) throws IOException {
            Utils.nonNull(b);
            this.out.write(b);
            ++this.count;
        }

        @Override
        public void write(byte[] b) throws IOException {
            Utils.nonNull(b);
            this.out.write(b);
            this.count += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Utils.nonNull(b);
            ParamUtils.isValidArrayOffsetAndRangeLength(off, len, b.length, "input buffer");
            this.out.write(b, off, len);
            this.count += (long)len;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

