/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.util.Locatable;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.utils.IntervalPileup;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;

class ByteMapIntervalPileup
implements IntervalPileup {
    private final ReferenceBases referenceBases;
    private final List<GATKRead> reads;
    private final List<IntervalPileup.Element> elements;
    private final Int2ObjectMap<IntervalPileup.Element> elementByIndex;
    private final Map<GATKRead, IntervalPileup.Element> elementByRead;
    private final int width;
    private final int height;
    private byte[][] bases;
    private byte[][] quals;
    private final List<Insert> insertsBuffer = new ArrayList<Insert>(10);
    private final IntList insertsBufferOffsets = new IntArrayList(10);

    ByteMapIntervalPileup(ReferenceBases referenceBases, List<GATKRead> reads) {
        this.referenceBases = referenceBases;
        this.width = referenceBases.getInterval().size();
        SimpleInterval referenceInterval = referenceBases.getInterval();
        int referenceStart = referenceInterval.getStart();
        int referenceEnd = referenceInterval.getEnd();
        this.reads = Collections.unmodifiableList(reads.stream().filter(read -> !read.isUnmapped() && read.getStart() <= referenceEnd && read.getEnd() >= referenceStart).sorted(Comparator.comparingInt(Locatable::getStart).thenComparing(Locatable::getEnd).thenComparing(GATKRead::getName)).collect(Collectors.toList()));
        this.elements = new ArrayList<IntervalPileup.Element>(this.reads.size());
        this.elementByIndex = new Int2ObjectOpenHashMap(this.reads.size());
        this.elementByRead = new HashMap<GATKRead, IntervalPileup.Element>(this.reads.size());
        this.height = this.reads.size();
        this.bases = new byte[this.height][this.width];
        this.quals = new byte[this.height][this.width];
        for (int i = 0; i < this.height; ++i) {
            Element element = new Element(this, this.reads.get(i), i);
            this.elements.add(element);
            this.elementByIndex.put(i, (Object)element);
            this.elementByRead.put(this.reads.get(i), element);
        }
    }

    @Override
    public List<GATKRead> reads() {
        return this.reads;
    }

    @Override
    public ReferenceBases reference() {
        return this.referenceBases;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public byte baseAt(int row, int column) {
        return this.bases[row][column];
    }

    @Override
    public byte qualAt(int row, int column) {
        return this.quals[row][column];
    }

    @Override
    public IntervalPileup.Insert insertAt(int row, int column) {
        IntervalPileup.Element element = (IntervalPileup.Element)this.elementByIndex.get(row);
        return element != null ? element.insertAt(column) : null;
    }

    @Override
    public GATKRead readAt(int row, int column) {
        IntervalPileup.Element element = this.elements.get(row);
        if (element.minColumn() > column || element.maxColumn() < column) {
            return null;
        }
        return element.read();
    }

    @Override
    public List<GATKRead> readsAt(int row, int column) {
        GATKRead read = this.readAt(row, column);
        return read != null ? Collections.singletonList(read) : Collections.emptyList();
    }

    @Override
    public IntervalPileup.Element element(GATKRead read) {
        return this.elementByRead.get(read);
    }

    @Override
    public boolean hasInsertAt(int row, int column) {
        IntervalPileup.Element element = this.elements.get(row);
        return element.hasInsertAt(column);
    }

    @Override
    public byte[] insertBasesAt(int row, int column) {
        IntervalPileup.Element element = this.elements.get(row);
        return element.insertBasesAt(column);
    }

    @Override
    public byte[] insertQualsAt(int row, int column) {
        IntervalPileup.Element element = this.elements.get(row);
        return element.insertQualsAt(column);
    }

    static class Element
    implements IntervalPileup.Element {
        private final GATKRead read;
        private final int row;
        private final int minColumn;
        private final int maxColumn;
        private final Int2ObjectMap<Insert> inserts;
        private final ByteMapIntervalPileup pileup;

        private Element(ByteMapIntervalPileup pileup, GATKRead read, int row) {
            this.pileup = pileup;
            this.row = row;
            this.read = read;
            Cigar cigar = read.getCigar();
            int referenceWidth = cigar.getReferenceLength();
            int referenceOffset = read.getStart() - pileup.referenceBases.getInterval().getStart();
            int readOffset = 0;
            this.minColumn = Math.max(0, referenceOffset);
            this.maxColumn = Math.min(pileup.width - 1, referenceOffset + referenceWidth - 1);
            Arrays.fill(pileup.bases[row], 0, this.minColumn, (byte)-1);
            Arrays.fill(pileup.bases[row], this.maxColumn + 1, pileup.width, (byte)-1);
            Arrays.fill(pileup.quals[row], 0, this.minColumn, (byte)-1);
            Arrays.fill(pileup.quals[row], this.maxColumn + 1, pileup.width, (byte)-1);
            List cigarElements = cigar.getCigarElements();
            pileup.insertsBuffer.clear();
            pileup.insertsBufferOffsets.clear();
            for (int i = 0; referenceOffset <= this.maxColumn + 1 && i < cigarElements.size(); ++i) {
                CigarElement element = (CigarElement)cigarElements.get(i);
                CigarOperator op = element.getOperator();
                int length = element.getLength();
                int newReferenceOffset = referenceOffset + (op.consumesReferenceBases() ? length : 0);
                int newReadOffset = readOffset + (op.consumesReadBases() ? length : 0);
                if (newReferenceOffset >= this.minColumn) {
                    if (op.isAlignment()) {
                        int leftOverhang = referenceOffset < this.minColumn ? this.minColumn - referenceOffset : 0;
                        int from = referenceOffset + leftOverhang;
                        int len = newReferenceOffset > this.maxColumn ? this.maxColumn + 1 - from : length - leftOverhang;
                        int readFrom = readOffset + leftOverhang;
                        int copiedBases = read.copyBases(readFrom, pileup.bases[row], from, len);
                        int copiedQuals = read.copyBaseQualities(readFrom, pileup.quals[row], from, len);
                        if (copiedBases < len) {
                            Arrays.fill(pileup.bases[row], from + copiedBases, from + len - copiedBases, (byte)78);
                        }
                        if (copiedQuals < len) {
                            Arrays.fill(pileup.quals[row], from + copiedQuals, from + len - copiedQuals, (byte)-1);
                        }
                    } else if (op == CigarOperator.I) {
                        pileup.insertsBuffer.add(new Insert(read, readOffset, referenceOffset - 1, length));
                        pileup.insertsBufferOffsets.add(referenceOffset - 1);
                    } else if (op == CigarOperator.D || op == CigarOperator.N) {
                        int from = referenceOffset < this.minColumn ? this.minColumn : referenceOffset;
                        int len = (newReferenceOffset > this.maxColumn ? this.maxColumn + 1 : newReferenceOffset) - from;
                        Arrays.fill(pileup.bases[row], from, from + len, (byte)45);
                        Arrays.fill(pileup.quals[row], from, from + len, (byte)-1);
                    }
                }
                readOffset = newReadOffset;
                referenceOffset = newReferenceOffset;
            }
            Element.mergeAdjacentInserts(read, pileup.insertsBuffer, pileup.insertsBufferOffsets);
            this.inserts = Element.consolidateInserts(pileup.insertsBuffer, pileup.insertsBufferOffsets);
        }

        private static Int2ObjectMap<Insert> consolidateInserts(List<Insert> inserts, IntList offsets) {
            int size = inserts.size();
            if (size == 0) {
                return Int2ObjectMaps.emptyMap();
            }
            if (size == 1) {
                return Int2ObjectMaps.singleton((Integer)((Integer)offsets.get(0)), (Object)inserts.get(0));
            }
            Int2ObjectArrayMap result = size < 5 ? new Int2ObjectArrayMap(size) : new Int2ObjectOpenHashMap(size);
            for (int ins = 0; ins < size; ++ins) {
                result.put(offsets.get(ins), (Object)inserts.get(ins));
            }
            return result;
        }

        private static void mergeAdjacentInserts(GATKRead read, List<Insert> inserts, IntList offsets) {
            for (int i = inserts.size() - 1; i > 0; --i) {
                if (offsets.get(i) != offsets.get(i - 1)) continue;
                Insert left = inserts.get(i - 1);
                Insert right = inserts.get(i);
                Insert merged = new Insert(read, left.offset, left.column, left.length + right.length);
                inserts.remove(i);
                inserts.set(i - 1, merged);
                offsets.remove(i);
            }
        }

        @Override
        public GATKRead read() {
            return this.read;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int minColumn() {
            return this.minColumn;
        }

        @Override
        public int maxColumn() {
            return this.maxColumn;
        }

        @Override
        public boolean hasInsertAt(int column) {
            return this.inserts.containsKey(column);
        }

        @Override
        public int insertSize(int column) {
            Insert insert = (Insert)this.inserts.get(column);
            return insert != null ? insert.length() : 0;
        }

        @Override
        public int copyInsertQuals(int column, byte[] dest, int offset, int maxLength) {
            Utils.nonNull(dest);
            Utils.validIndex(offset, dest.length);
            Utils.validIndex(offset + maxLength, dest.length);
            Insert insert = (Insert)this.inserts.get(column);
            if (maxLength != 0 && insert != null) {
                return insert.copyQuals(0, dest, offset, maxLength);
            }
            return 0;
        }

        @Override
        public int copyInsertBases(int column, byte[] dest, int offset, int maxLength) {
            Utils.nonNull(dest);
            Utils.validIndex(offset, dest.length);
            Utils.validIndex(offset + maxLength, dest.length);
            Insert insert = (Insert)this.inserts.get(column);
            if (maxLength != 0 && insert != null) {
                return insert.copyBases(0, dest, offset, maxLength);
            }
            return 0;
        }

        @Override
        public byte[] insertBasesAt(int column) {
            Insert insert = (Insert)this.inserts.get(column);
            return insert != null ? insert.bases() : null;
        }

        @Override
        public byte[] insertQualsAt(int column) {
            Insert insert = (Insert)this.inserts.get(column);
            return insert != null ? insert.quals() : null;
        }

        @Override
        public Insert insertAt(int column) {
            return (Insert)this.inserts.get(column);
        }

        @Override
        public List<IntervalPileup.Insert> inserts() {
            return new ArrayList<IntervalPileup.Insert>((Collection<IntervalPileup.Insert>)this.inserts.values());
        }

        @Override
        public byte baseAt(int column) {
            return this.pileup.bases[this.row][column];
        }

        @Override
        public byte qualAt(int column) {
            return this.pileup.quals[this.row][column];
        }
    }

    static class Insert
    implements IntervalPileup.Insert {
        private final GATKRead enclosingRead;
        private final int offset;
        private final int length;
        private final int column;
        private transient int hashCode = 0;

        Insert(GATKRead enclosingRead, int offset, int column, int length) {
            this.enclosingRead = enclosingRead;
            this.offset = offset;
            this.length = length;
            this.column = column;
        }

        @Override
        public int column() {
            return this.column;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public byte[] bases() {
            byte[] result = new byte[this.length];
            int copied = this.enclosingRead.copyBases(this.offset, result, 0, this.length);
            if (copied < this.length) {
                Arrays.fill(result, copied, result.length, (byte)78);
            }
            return result;
        }

        @Override
        public byte[] quals() {
            byte[] result = new byte[this.length];
            int copied = this.enclosingRead.copyBaseQualities(this.offset, result, 0, this.length);
            if (copied < this.length) {
                Arrays.fill(result, copied, result.length, (byte)-1);
            }
            return result;
        }

        @Override
        public int copyBases(int offset, byte[] dest, int destOffset, int maxLength) {
            int actualMaxLength = Math.min(this.length, maxLength);
            int copied = this.enclosingRead.copyBases(this.offset + offset, dest, destOffset, actualMaxLength);
            if (copied < actualMaxLength) {
                Arrays.fill(dest, destOffset + copied, destOffset + actualMaxLength, (byte)78);
            }
            return actualMaxLength;
        }

        @Override
        public int copyQuals(int offset, byte[] dest, int destOffset, int maxLength) {
            int actualMaxLength = Math.min(this.length, maxLength);
            int copied = this.enclosingRead.copyBaseQualities(this.offset + offset, dest, destOffset, actualMaxLength);
            if (copied < actualMaxLength) {
                Arrays.fill(dest, destOffset + copied, destOffset + actualMaxLength, (byte)78);
            }
            return actualMaxLength;
        }

        @Override
        public int hashCode() {
            byte[] readBases;
            if (this.hashCode == 0 && (readBases = this.enclosingRead.getBasesNoCopy()) != null && readBases.length > this.offset) {
                int i;
                int to = this.offset + this.length;
                int to2 = to <= readBases.length ? to : readBases.length;
                this.hashCode = 1;
                for (i = this.offset; i < to2; ++i) {
                    this.hashCode = this.hashCode * 31 + readBases[i];
                }
                while (i < to) {
                    this.hashCode = this.hashCode * 31 + 78;
                    ++i;
                }
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(Object other) {
            return other == this || other instanceof Insert && this.equals((IntervalPileup.Insert)other);
        }

        private boolean equals(IntervalPileup.Insert other) {
            return this.length == other.length() && this.hashCode() == other.hashCode() && this.equalBases(other) && this.equalQualities(other);
        }

        private boolean equalBases(IntervalPileup.Insert other) {
            if (other instanceof Insert) {
                this.equalBases((Insert)other);
            }
            byte[] otherBases = other.bases();
            byte[] readBases = this.enclosingRead.getBasesNoCopy();
            for (int i = 0; i < otherBases.length; ++i) {
                if (otherBases[i] == readBases[this.offset + i]) continue;
                return false;
            }
            return true;
        }

        private boolean equalBases(Insert other) {
            byte[] otherBases = other.enclosingRead.getBasesNoCopy();
            byte[] thisBases = this.enclosingRead.getBasesNoCopy();
            for (int i = 0; i < this.length; ++i) {
                if (otherBases[other.offset + i] == thisBases[this.offset + i]) continue;
                return false;
            }
            return true;
        }

        private boolean equalQualities(IntervalPileup.Insert other) {
            if (other instanceof Insert) {
                this.equalQualities((Insert)other);
            }
            byte[] otherQuals = other.quals();
            byte[] thisQuals = this.enclosingRead.getBaseQualitiesNoCopy();
            for (int i = 0; i < otherQuals.length; ++i) {
                if (otherQuals[i] == thisQuals[this.offset + i]) continue;
                return false;
            }
            return true;
        }

        private boolean equalQualities(Insert other) {
            byte[] otherQuals = other.enclosingRead.getBaseQualitiesNoCopy();
            byte[] thisQuals = this.enclosingRead.getBaseQualitiesNoCopy();
            for (int i = 0; i < this.length; ++i) {
                if (otherQuals[other.offset + i] == thisQuals[this.offset + i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return new String(this.bases()) + "/" + new String(this.quals());
        }
    }
}

