/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.ClassFinder;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static boolean canMakeInstances(Class<?> clazz) {
        return clazz != null && !clazz.isPrimitive() && !clazz.isSynthetic() && !clazz.isInterface() && !clazz.isLocalClass() && !Modifier.isPrivate(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers()) && clazz.getConstructors().length != 0;
    }

    public static <T> List<T> makeInstancesOfSubclasses(Class<? extends T> clazz, Package pack) {
        Utils.nonNull(clazz, "class");
        Utils.nonNull(pack, "package");
        ClassFinder finder = new ClassFinder();
        finder.find(pack.getName(), clazz);
        Set classes = finder.getClasses();
        ArrayList<T> results = new ArrayList<T>(classes.size());
        for (Class found : classes) {
            T instance = ClassUtils.makeInstanceOf(found);
            if (instance == null) continue;
            results.add(instance);
        }
        return results;
    }

    public static <T> T makeInstanceOf(Class<T> clazz) {
        if (ClassUtils.canMakeInstances(clazz)) {
            try {
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new GATKException("Problem making an instance of " + clazz + " Do check that the class has a non-arg constructor", e);
            }
        }
        return null;
    }

    public static List<String> knownSubInterfaceSimpleNames(Class<?> iface) {
        Utils.nonNull(iface);
        Utils.validateArg(iface.isInterface(), iface + " is not an interface");
        return ClassUtils.knownSubInterfaces(iface).stream().map(c -> c.getSimpleName()).collect(Collectors.toList());
    }

    public static Set<Class<?>> knownSubInterfaces(Class<?> iface) {
        ClassFinder finder = new ClassFinder();
        finder.find(iface.getPackage().getName(), iface);
        return finder.getClasses().stream().filter(cl -> !cl.equals(iface) && cl.isInterface()).collect(Collectors.toSet());
    }

    public static List<Class<?>> getClassesOfType(Class<?> targetClass, List<Class<?>> classesToSearch) {
        ArrayList classList = new ArrayList();
        for (Class<?> clazz : classesToSearch) {
            if (!targetClass.isAssignableFrom(clazz)) continue;
            classList.add(clazz);
        }
        return classList;
    }
}

