/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class CompressedDataList<T>
implements Iterable<T> {
    protected Map<T, Integer> valueCounts = new HashMap<T, Integer>();

    public Map<T, Integer> getValueCounts() {
        return this.valueCounts;
    }

    public boolean isEmpty() {
        return this.valueCounts.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        Iterator it = new Iterator<T>(){
            private Iterator<T> keySetIterator;
            private T currentKey;
            private int currentValueIndex;
            private int currentValueSize;
            {
                this.keySetIterator = CompressedDataList.this.valueCounts.keySet().iterator();
                this.currentKey = CompressedDataList.this.valueCounts.isEmpty() ? null : this.keySetIterator.next();
                this.currentValueIndex = 0;
                this.currentValueSize = CompressedDataList.this.valueCounts.isEmpty() ? 0 : CompressedDataList.this.valueCounts.get(this.currentKey);
            }

            @Override
            public boolean hasNext() {
                return !CompressedDataList.this.valueCounts.isEmpty() && (this.keySetIterator.hasNext() || this.currentValueIndex < this.currentValueSize);
            }

            @Override
            public T next() {
                Object retKey = this.currentKey;
                ++this.currentValueIndex;
                if (this.currentValueIndex == this.currentValueSize && this.keySetIterator.hasNext()) {
                    this.currentKey = this.keySetIterator.next();
                    this.currentValueIndex = 0;
                    this.currentValueSize = CompressedDataList.this.valueCounts.get(this.currentKey);
                }
                return retKey;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return it;
    }

    public String toString() {
        String str = "";
        Object[] keys = this.valueCounts.keySet().toArray();
        Arrays.sort(keys);
        for (Object i : keys) {
            if (!str.isEmpty()) {
                str = str + ",";
            }
            str = str + i + "," + this.valueCounts.get(i);
        }
        return str;
    }

    public void add(T val) {
        this.add(val, 1);
    }

    public void add(T val, int count) {
        if (this.valueCounts.containsKey(val)) {
            this.valueCounts.put(val, this.valueCounts.get(val) + count);
        } else {
            this.valueCounts.put(val, count);
        }
    }

    public void add(CompressedDataList<T> obj) {
        for (Map.Entry<T, Integer> pair : obj.valueCounts.entrySet()) {
            this.add(pair.getKey(), pair.getValue());
        }
    }
}

