/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.HypergeometricDistribution;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;

public final class FisherExactTest {
    private static final double REL_ERR = 0.999999;

    public static double twoSidedPValue(int[][] normalizedTable) {
        Utils.nonNull(normalizedTable);
        Utils.validateArg(normalizedTable.length == 2, () -> "input must be 2x2 " + Arrays.deepToString((Object[])normalizedTable));
        Utils.validateArg(normalizedTable[0] != null && normalizedTable[0].length == 2, () -> "input must be 2x2 " + Arrays.deepToString((Object[])normalizedTable));
        Utils.validateArg(normalizedTable[1] != null && normalizedTable[1].length == 2, () -> "input must be 2x2 " + Arrays.deepToString((Object[])normalizedTable));
        int[][] x = normalizedTable;
        int m = x[0][0] + x[0][1];
        int n = x[1][0] + x[1][1];
        int k = x[0][0] + x[1][0];
        int lo = Math.max(0, k - n);
        int hi = Math.min(k, m);
        IndexRange support = new IndexRange(lo, hi + 1);
        if (support.size() <= 1) {
            return 1.0;
        }
        HypergeometricDistribution dist = new HypergeometricDistribution(null, m + n, m, k);
        double[] logds = support.mapToDouble(arg_0 -> ((AbstractIntegerDistribution)dist).logProbability(arg_0));
        double threshold = logds[x[0][0] - lo] * 0.999999;
        double[] log10ds = DoubleStream.of(logds).filter(d -> d <= threshold).map(MathUtils::logToLog10).toArray();
        double pValue = MathUtils.sumLog10(log10ds);
        return Math.min(pValue, 1.0);
    }
}

