/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.GenomeLoc;
import org.broadinstitute.hellbender.utils.GenomeLocParser;
import org.broadinstitute.hellbender.utils.IntervalMergingRule;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.Utils;

public final class GenomeLocSortedSet
extends AbstractSet<GenomeLoc> {
    private static final Logger logger = LogManager.getLogger(GenomeLocSortedSet.class);
    private final GenomeLocParser genomeLocParser;
    private final List<GenomeLoc> mArray = new ArrayList<GenomeLoc>();
    private int previousOverlapSearchIndex = -1;

    public GenomeLocSortedSet(GenomeLocParser parser) {
        this.genomeLocParser = Utils.nonNull(parser);
    }

    public GenomeLocSortedSet(GenomeLocParser parser, GenomeLoc e) {
        this(parser);
        this.add(e);
    }

    public GenomeLocSortedSet(GenomeLocParser parser, Collection<GenomeLoc> l) {
        this(parser);
        ArrayList<GenomeLoc> sorted = new ArrayList<GenomeLoc>(l);
        Collections.sort(sorted);
        this.mArray.addAll(IntervalUtils.mergeIntervalLocations(sorted, IntervalMergingRule.OVERLAPPING_ONLY));
    }

    public GenomeLocParser getGenomeLocParser() {
        return this.genomeLocParser;
    }

    @Override
    public Iterator<GenomeLoc> iterator() {
        return this.mArray.iterator();
    }

    @Override
    public int size() {
        return this.mArray.size();
    }

    public long coveredSize() {
        long s = 0L;
        for (GenomeLoc e : this) {
            s += (long)e.size();
        }
        return s;
    }

    public long sizeBeforeLoc(GenomeLoc loc) {
        long s = 0L;
        for (GenomeLoc e : this) {
            if (e.isBefore(loc)) {
                s += (long)e.size();
                continue;
            }
            if (e.isPast(loc)) break;
            s += (long)(loc.getStart() - e.getStart());
        }
        return s;
    }

    @Override
    public boolean isEmpty() {
        return this.mArray.isEmpty();
    }

    public boolean overlaps(GenomeLoc loc) {
        if (this.mArray.isEmpty()) {
            return false;
        }
        if (this.previousOverlapSearchIndex != -1 && this.overlapsAtOrImmediatelyAfterCachedIndex(loc, true)) {
            return true;
        }
        this.previousOverlapSearchIndex = Collections.binarySearch(this.mArray, loc);
        if (this.previousOverlapSearchIndex >= 0) {
            return true;
        }
        this.previousOverlapSearchIndex = Math.max(0, -1 * this.previousOverlapSearchIndex - 2);
        return this.overlapsAtOrImmediatelyAfterCachedIndex(loc, false);
    }

    private boolean overlapsAtOrImmediatelyAfterCachedIndex(GenomeLoc loc, boolean updateCachedIndex) {
        if (this.mArray.get(this.previousOverlapSearchIndex).overlapsP(loc)) {
            return true;
        }
        boolean returnValue = false;
        if (this.previousOverlapSearchIndex < this.mArray.size() - 1) {
            returnValue = this.mArray.get(this.previousOverlapSearchIndex + 1).overlapsP(loc);
            if (updateCachedIndex) {
                ++this.previousOverlapSearchIndex;
            }
        }
        return returnValue;
    }

    public List<GenomeLoc> getOverlapping(GenomeLoc loc) {
        int index = Collections.binarySearch(this.mArray, loc);
        if (index >= 0) {
            return Collections.singletonList(loc);
        }
        int start = Math.max(-(index + 1) - 1, 0);
        int size = this.mArray.size();
        LinkedList<GenomeLoc> overlapping = new LinkedList<GenomeLoc>();
        for (int i = start; i < size; ++i) {
            GenomeLoc myLoc = this.mArray.get(i);
            if (loc.overlapsP(myLoc)) {
                overlapping.add(myLoc);
                continue;
            }
            if (myLoc.isPast(loc)) break;
        }
        return overlapping;
    }

    protected List<GenomeLoc> getOverlappingFullSearch(GenomeLoc loc) {
        LinkedList<GenomeLoc> overlapping = new LinkedList<GenomeLoc>();
        for (GenomeLoc myLoc : this.mArray) {
            if (!loc.overlapsP(myLoc)) continue;
            overlapping.add(myLoc);
        }
        return overlapping;
    }

    @Override
    public boolean add(GenomeLoc loc) {
        return this.add(loc, false);
    }

    public boolean addRegion(GenomeLoc loc) {
        return this.add(loc, true);
    }

    public boolean add(GenomeLoc loc, boolean mergeIfIntervalOverlaps) {
        if (loc == null) {
            return false;
        }
        if (this.mArray.isEmpty() || loc.isPast(this.mArray.get(this.mArray.size() - 1))) {
            return this.mArray.add(loc);
        }
        int binarySearchIndex = Collections.binarySearch(this.mArray, loc);
        if (binarySearchIndex >= 0) {
            if (mergeIfIntervalOverlaps) {
                return false;
            }
            throw new IllegalArgumentException("GenomeLocSortedSet already contains the GenomeLoc " + loc);
        }
        int insertionIndex = -1 * (binarySearchIndex + 1);
        if (!this.mergeOverlappingIntervalsFromAdd(loc, insertionIndex, !mergeIfIntervalOverlaps)) {
            this.mArray.add(insertionIndex, loc);
        }
        return true;
    }

    private boolean mergeOverlappingIntervalsFromAdd(GenomeLoc loc, int insertionIndex, boolean throwExceptionIfOverlapping) {
        if (insertionIndex != 0 && loc.overlapsP(this.mArray.get(insertionIndex - 1))) {
            if (throwExceptionIfOverlapping) {
                throw new IllegalArgumentException(String.format("GenomeLocSortedSet contains a GenomeLoc (%s) that overlaps with the provided one (%s)", this.mArray.get(insertionIndex - 1).toString(), loc.toString()));
            }
            this.mArray.set(insertionIndex - 1, this.mArray.get(insertionIndex - 1).merge(loc));
            return true;
        }
        if (insertionIndex < this.mArray.size() && loc.overlapsP(this.mArray.get(insertionIndex))) {
            if (throwExceptionIfOverlapping) {
                throw new IllegalArgumentException(String.format("GenomeLocSortedSet contains a GenomeLoc (%s) that overlaps with the provided one (%s)", this.mArray.get(insertionIndex).toString(), loc.toString()));
            }
            this.mArray.set(insertionIndex, this.mArray.get(insertionIndex).merge(loc));
            return true;
        }
        return false;
    }

    public GenomeLocSortedSet subtractRegions(GenomeLocSortedSet toRemoveSet) {
        LinkedList<GenomeLoc> good = new LinkedList<GenomeLoc>();
        Stack<GenomeLoc> toProcess = new Stack<GenomeLoc>();
        Stack<GenomeLoc> toExclude = new Stack<GenomeLoc>();
        toProcess.addAll(this.mArray);
        Collections.reverse(toProcess);
        toExclude.addAll(toRemoveSet.mArray);
        Collections.reverse(toExclude);
        int i = 0;
        while (!toProcess.empty()) {
            GenomeLoc e;
            if (toExclude.empty()) {
                good.addAll(toProcess);
                break;
            }
            GenomeLoc p = (GenomeLoc)toProcess.peek();
            if (p.overlapsP(e = (GenomeLoc)toExclude.peek())) {
                toProcess.pop();
                for (GenomeLoc newP : p.subtract(e)) {
                    toProcess.push(newP);
                }
            } else if (p.compareContigs(e) < 0) {
                good.add((GenomeLoc)toProcess.pop());
            } else if (p.compareContigs(e) > 0) {
                toExclude.pop();
            } else if (p.getStop() < e.getStart()) {
                good.add((GenomeLoc)toProcess.pop());
            } else if (e.getStop() < p.getStart()) {
                toExclude.pop();
            } else {
                throw new GATKException("BUG: unexpected condition: p=" + p + ", e=" + e);
            }
            if (i++ % 10000 != 0) continue;
            logger.debug("removeRegions operation: i = " + i);
        }
        return GenomeLocSortedSet.createSetFromList(this.genomeLocParser, good);
    }

    public void remove(GenomeLoc location) {
        Utils.validateArg(this.mArray.contains(location), () -> "Unable to remove location: " + location + ", not in the list");
        this.mArray.remove(location);
    }

    public static GenomeLocSortedSet createSetFromSequenceDictionary(SAMSequenceDictionary dict) {
        GenomeLocParser parser = new GenomeLocParser(dict);
        GenomeLocSortedSet returnSortedSet = new GenomeLocSortedSet(parser);
        for (SAMSequenceRecord sequence : dict.getSequences()) {
            returnSortedSet.add(parser.createOverEntireContig(sequence.getSequenceName()));
        }
        return returnSortedSet;
    }

    public static GenomeLocSortedSet createSetFromList(GenomeLocParser parser, List<GenomeLoc> locs) {
        GenomeLocSortedSet set = new GenomeLocSortedSet(parser);
        set.addAll(locs);
        return set;
    }

    public List<GenomeLoc> toList() {
        return this.mArray;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (GenomeLoc e : this) {
            s.append(" ");
            s.append(e.toString());
        }
        s.append("]");
        return s.toString();
    }
}

