/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.hellbender.utils.GenotypeCounts;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import picard.util.MathUtil;

public final class GenotypeUtils {
    private GenotypeUtils() {
    }

    public static boolean isDiploidWithLikelihoods(Genotype g) {
        return Utils.nonNull(g).hasLikelihoods() && g.getPloidy() == 2;
    }

    public static GenotypeCounts computeDiploidGenotypeCounts(VariantContext vc, GenotypesContext genotypes, boolean roundContributionFromEachGenotype) {
        Utils.nonNull(vc, "vc");
        Utils.nonNull(genotypes, "genotypes");
        boolean idxAA = false;
        boolean idxAB = true;
        int idxBB = 2;
        double genotypeWithTwoRefsCount = 0.0;
        double genotypesWithOneRefCount = 0.0;
        double genotypesWithNoRefsCount = 0.0;
        for (Genotype g : genotypes) {
            double[] biallelicLikelihoods;
            if (!GenotypeUtils.isDiploidWithLikelihoods(g)) continue;
            double[] normalizedLikelihoods = MathUtils.normalizeFromLog10ToLinearSpace(g.getLikelihoods().getAsVector());
            if (vc.getAlternateAlleles().size() > 1) {
                int maxInd = MathUtil.indexOfMax((double[])normalizedLikelihoods);
                GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair((int)maxInd);
                if (alleles.alleleIndex1 != 0 && alleles.alleleIndex2 != 0) {
                    genotypesWithNoRefsCount += 1.0;
                    continue;
                }
                double maxLikelihood = normalizedLikelihoods[1];
                int hetIndex = 1;
                int varIndex = 2;
                for (Allele currAlt : vc.getAlternateAlleles()) {
                    int[] idxVector = vc.getGLIndicesOfAlternateAllele(currAlt);
                    int tempIndex = idxVector[1];
                    if (!(normalizedLikelihoods[tempIndex] > maxLikelihood)) continue;
                    maxLikelihood = normalizedLikelihoods[tempIndex];
                    hetIndex = tempIndex;
                    varIndex = idxVector[2];
                }
                biallelicLikelihoods = MathUtils.normalizeSumToOne(new double[]{normalizedLikelihoods[0], normalizedLikelihoods[hetIndex], normalizedLikelihoods[varIndex]});
            } else {
                biallelicLikelihoods = normalizedLikelihoods;
            }
            double refLikelihood = biallelicLikelihoods[0];
            double hetLikelihood = biallelicLikelihoods[1];
            double varLikelihood = biallelicLikelihoods[2];
            if (roundContributionFromEachGenotype) {
                genotypeWithTwoRefsCount += (double)MathUtils.fastRound(refLikelihood);
                if (refLikelihood != hetLikelihood) {
                    genotypesWithOneRefCount += (double)MathUtils.fastRound(hetLikelihood);
                }
                if (varLikelihood == hetLikelihood) continue;
                genotypesWithNoRefsCount += (double)MathUtils.fastRound(varLikelihood);
                continue;
            }
            genotypeWithTwoRefsCount += refLikelihood;
            genotypesWithOneRefCount += hetLikelihood;
            genotypesWithNoRefsCount += varLikelihood;
        }
        return new GenotypeCounts(genotypeWithTwoRefsCount, genotypesWithOneRefCount, genotypesWithNoRefsCount);
    }
}

