/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.util.Arrays;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.CompressedDataList;

public class Histogram {
    private Double binSize;
    private String precisionFormat;
    private String printDelim;
    private final Double BIN_EPSILON = 0.01;
    private CompressedDataList<Integer> dataList = new CompressedDataList();

    public Histogram() {
        this.binSize = 0.1;
        this.precisionFormat = "%.1f";
    }

    public Histogram(Double binSize) {
        this.binSize = binSize;
        this.precisionFormat = "%." + Math.round(-Math.log10(binSize)) + "f";
    }

    public void add(Double d) {
        if (d.isNaN()) {
            return;
        }
        long binKey = this.getBinnedValue(d);
        if (!this.isValidBinKey(binKey)) {
            throw new GATKException("Histogram values are suspiciously extreme.  Failed to add " + d + " to the Histogram.");
        }
        this.dataList.add((int)binKey);
    }

    public void add(Double d, int count) {
        if (count < 1) {
            throw new GATKException("Cannot add non-positive counts to Histogram.");
        }
        long binKey = this.getBinnedValue(d);
        if (!this.isValidBinKey(binKey)) {
            throw new GATKException("Histogram values are suspiciously extreme.  Failed to add " + d + " to the Histogram.");
        }
        this.dataList.add((int)binKey, count);
    }

    public void add(Histogram h) {
        if (!this.binSize.equals(h.binSize)) {
            throw new GATKException("Histogram bin sizes are mismatched -- cannot add bin size " + this.binSize + " to " + h.binSize);
        }
        this.dataList.add(h.dataList);
    }

    public Integer get(Double d) {
        long binKey = this.getBinnedValue(d);
        if (this.isValidBinKey(binKey)) {
            return this.dataList.getValueCounts().get((int)binKey);
        }
        throw new GATKException("Requested value is suspiciously extreme.  Failed to retrieve " + d + " from the Histogram.");
    }

    public Double median() {
        int numItems = 0;
        for (int count : this.dataList.valueCounts.values()) {
            numItems += count;
        }
        boolean oddNumberValues = true;
        if (numItems % 2 == 0) {
            oddNumberValues = false;
        }
        int medianIndex = (numItems + 1) / 2;
        int counter = 0;
        Double firstMedian = null;
        for (Integer key : this.dataList.valueCounts.keySet()) {
            if ((counter += this.dataList.valueCounts.get(key).intValue()) > medianIndex) {
                if (firstMedian == null) {
                    return (double)key.intValue() * this.binSize;
                }
                return (firstMedian + (double)key.intValue()) / 2.0 * this.binSize;
            }
            if (counter != medianIndex) continue;
            if (oddNumberValues) {
                return (double)key.intValue() * this.binSize;
            }
            firstMedian = (double)key;
        }
        return null;
    }

    private long getBinnedValue(double d) {
        return Math.round(Math.floor((d + this.BIN_EPSILON * this.binSize) / this.binSize));
    }

    private boolean isValidBinKey(long binnedValue) {
        return binnedValue <= Integer.MAX_VALUE && binnedValue >= Integer.MIN_VALUE;
    }

    public String toString() {
        this.printDelim = ",";
        String str = "";
        Object[] keys = this.dataList.valueCounts.keySet().toArray();
        if (keys.length == 0) {
            return Double.toString(Double.NaN);
        }
        Arrays.sort(keys);
        for (Object i : keys) {
            if (!str.isEmpty()) {
                str = str + this.printDelim;
            }
            str = str + String.format(this.precisionFormat, (double)((Integer)i).intValue() * this.binSize) + this.printDelim + this.dataList.valueCounts.get(i);
        }
        return str;
    }

    public boolean isEmpty() {
        return this.dataList.isEmpty();
    }
}

