/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class HttpUtils {
    private static CloseableHttpClient client;

    private HttpUtils() {
    }

    public static synchronized CloseableHttpClient getClient() {
        if (client == null) {
            client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setServiceUnavailableRetryStrategy(new ServiceUnavailableRetryStrategy(){
                private int interval = 1;

                public boolean retryRequest(HttpResponse resp, int executionCount, HttpContext context) {
                    if (executionCount > 4) {
                        return false;
                    }
                    if (resp.getStatusLine() == null) {
                        return true;
                    }
                    int statusCode = resp.getStatusLine().getStatusCode();
                    return 500 <= statusCode && statusCode < 600;
                }

                public long getRetryInterval() {
                    int retryInterval = this.interval;
                    this.interval *= 2;
                    return retryInterval;
                }
            }).build();
        }
        return client;
    }
}

