/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import htsjdk.samtools.util.Locatable;
import java.io.PrintStream;
import org.broadinstitute.hellbender.utils.Utils;

public final class IGVUtils {
    private IGVUtils() {
    }

    public static void printIGVFormatHeader(PrintStream out, String graphType, String ... columns) {
        out.printf("#track graphType=%s%n", graphType);
        out.printf("Chromosome\tStart\tEnd\tFeature\t%s%n", Utils.join((CharSequence)"\t", columns));
    }

    public static void printIGVFormatRow(PrintStream out, Locatable loc, String featureName, double ... values) {
        out.printf("%s\t%d\t%d\t%s", loc.getContig(), loc.getStart() - 1, loc.getEnd(), featureName);
        for (double value : values) {
            out.print(String.format("\t%.5f", value));
        }
        out.println();
    }
}

