/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntUnaryOperator;
import org.broadinstitute.hellbender.utils.Utils;

public final class IndexRange {
    private int from;
    private int to;

    public IndexRange(int fromIndex, int toIndex) {
        this.from = fromIndex;
        this.to = toIndex;
        this.validate();
    }

    public void shift(int shift) {
        this.to += shift;
        this.from += shift;
        this.validate();
    }

    public void shiftLeft(int shift) {
        this.shift(-shift);
    }

    public void shiftStart(int shift) {
        this.from += shift;
        this.validate();
    }

    public void shiftStartLeft(int shift) {
        this.shiftStart(-shift);
    }

    public void shiftEnd(int shift) {
        this.to += shift;
        this.validate();
    }

    public void shiftEndLeft(int shift) {
        this.shiftEnd(-shift);
    }

    public int getStart() {
        return this.from;
    }

    public int getEnd() {
        return this.to;
    }

    private void validate() {
        Utils.validateArg(this.from <= this.to, "the range size cannot be negative");
        Utils.validateArg(this.from >= 0, "the range cannot contain negative indices");
    }

    public boolean isValidLength(int length) {
        return this.to <= length;
    }

    public int size() {
        return this.to - this.from;
    }

    public void forEach(IntConsumer lambda) {
        Utils.nonNull(lambda, "the lambda function cannot be null");
        for (int i = this.from; i < this.to; ++i) {
            lambda.accept(i);
        }
    }

    public double[] mapToDouble(IntToDoubleFunction lambda) {
        Utils.nonNull(lambda, "the lambda function cannot be null");
        double[] result = new double[this.size()];
        for (int i = this.from; i < this.to; ++i) {
            result[i - this.from] = lambda.applyAsDouble(i);
        }
        return result;
    }

    public double sum(IntToDoubleFunction lambda) {
        Utils.nonNull(lambda, "the lambda function cannot be null");
        double result = 0.0;
        for (int i = this.from; i < this.to; ++i) {
            result += lambda.applyAsDouble(i);
        }
        return result;
    }

    public int[] mapToInteger(IntUnaryOperator lambda) {
        Utils.nonNull(lambda, "the lambda function cannot be null");
        int[] result = new int[this.size()];
        for (int i = this.from; i < this.to; ++i) {
            result[i - this.from] = lambda.applyAsInt(i);
        }
        return result;
    }

    public List<Integer> filter(IntPredicate predicate) {
        Utils.nonNull(predicate, "predicate may not be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        this.forEach(i -> {
            if (predicate.test(i)) {
                result.add(i);
            }
        });
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IndexRange)) {
            return false;
        }
        IndexRange otherCasted = (IndexRange)other;
        return otherCasted.from == this.from && otherCasted.to == this.to;
    }

    public int hashCode() {
        return (31 + Integer.hashCode(this.from)) * 31 + Integer.hashCode(this.to);
    }

    public String toString() {
        return String.format("%d-%d", this.from, this.to);
    }
}

