/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.Utils;

public abstract class IntToDoubleFunctionCache {
    private static final Logger logger = LogManager.getLogger(IntToDoubleFunctionCache.class);
    private double[] cache = new double[0];

    protected abstract int maxSize();

    protected abstract double compute(int var1);

    public double get(int i) {
        Utils.validateArg(i >= 0, () -> String.format("Cache doesn't apply to negative number %d", i));
        if (i >= this.cache.length) {
            if (i >= this.maxSize()) {
                return this.compute(i);
            }
            int newCapacity = Math.max(i + 10, 2 * this.cache.length);
            logger.debug("cache miss " + i + " > " + (this.cache.length - 1) + " expanding to " + newCapacity);
            this.expandCache(newCapacity);
        }
        return this.cache[i];
    }

    public synchronized void expandCache(int newCapacity) {
        if (newCapacity < this.cache.length) {
            return;
        }
        double[] newCache = new double[newCapacity + 1];
        System.arraycopy(this.cache, 0, newCache, 0, this.cache.length);
        for (int i = this.cache.length; i < newCache.length; ++i) {
            newCache[i] = this.compute(i);
        }
        this.cache = newCache;
    }

    public int size() {
        return this.cache.length;
    }
}

