/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.util.function.DoubleUnaryOperator;
import java.util.function.ToDoubleBiFunction;
import org.apache.commons.math3.analysis.integration.gauss.GaussIntegrator;
import org.apache.commons.math3.analysis.integration.gauss.GaussIntegratorFactory;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.MathUtils;

public class IntegrationUtils {
    private static final GaussIntegratorFactory integratorFactory = new GaussIntegratorFactory();

    public static double integrate(DoubleUnaryOperator integrand, double lowerBound, double upperBound, int numPoints) {
        GaussIntegrator integrator = integratorFactory.legendre(numPoints, lowerBound, upperBound);
        double[] gaussIntegrationWeights = new IndexRange(0, numPoints).mapToDouble(arg_0 -> ((GaussIntegrator)integrator).getWeight(arg_0));
        double[] gaussIntegrationAbscissas = new IndexRange(0, numPoints).mapToDouble(arg_0 -> ((GaussIntegrator)integrator).getPoint(arg_0));
        double[] integrands = MathUtils.applyToArrayInPlace(gaussIntegrationAbscissas, integrand::applyAsDouble);
        return MathUtils.dotProduct(gaussIntegrationWeights, integrands);
    }

    public static double integrate2d(ToDoubleBiFunction<Double, Double> getIntegrand, double xLowerBound, double xUpperBound, int xNumPoints, double yLowerBound, double yUpperBound, int yNumPoints) {
        GaussIntegrator xIntegrator = integratorFactory.legendre(xNumPoints, xLowerBound, xUpperBound);
        GaussIntegrator yIntegrator = integratorFactory.legendre(yNumPoints, yLowerBound, yUpperBound);
        double[] xIntegrationWeights = new IndexRange(0, xNumPoints).mapToDouble(arg_0 -> ((GaussIntegrator)xIntegrator).getWeight(arg_0));
        double[] xAbscissas = new IndexRange(0, xNumPoints).mapToDouble(arg_0 -> ((GaussIntegrator)xIntegrator).getPoint(arg_0));
        double[] yIntegrationWeights = new IndexRange(0, yNumPoints).mapToDouble(arg_0 -> ((GaussIntegrator)yIntegrator).getWeight(arg_0));
        double[] yAbscissas = new IndexRange(0, yNumPoints).mapToDouble(arg_0 -> ((GaussIntegrator)yIntegrator).getPoint(arg_0));
        double integral = 0.0;
        for (int i = 0; i < xNumPoints; ++i) {
            double x = xAbscissas[i];
            for (int j = 0; j < yNumPoints; ++j) {
                double y = yAbscissas[j];
                double integrand = getIntegrand.applyAsDouble(x, y);
                integral += xIntegrationWeights[i] * yIntegrationWeights[j] * integrand;
            }
        }
        return integral;
    }
}

