/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.Locatable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.ReadsDataSource;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.utils.ByteMapIntervalPileup;
import org.broadinstitute.hellbender.utils.EmptyIntervalPileup;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;

public interface IntervalPileup {
    public static final byte NO_BQ = -1;
    public static final byte GAP = 45;
    public static final byte NO_BASE = -1;

    public List<GATKRead> reads();

    public ReferenceBases reference();

    public int width();

    public int height();

    public byte baseAt(int var1, int var2);

    public byte qualAt(int var1, int var2);

    public Insert insertAt(int var1, int var2);

    public GATKRead readAt(int var1, int var2);

    public List<GATKRead> readsAt(int var1, int var2);

    public Element element(GATKRead var1);

    default public Element element(int row) {
        GATKRead read = this.reads().get(row);
        return this.element(read);
    }

    public boolean hasInsertAt(int var1, int var2);

    public byte[] insertBasesAt(int var1, int var2);

    public byte[] insertQualsAt(int var1, int var2);

    public static IntervalPileup of(Locatable loc, ReadsDataSource aln, ReferenceDataSource ref) {
        Utils.nonNull(loc);
        Utils.nonNull(aln);
        Utils.nonNull(ref);
        String contig = loc.getContig();
        int start = loc.getStart();
        int end = loc.getEnd();
        Utils.nonNull(contig);
        Utils.validate(start <= end, "start must be less than end");
        SAMSequenceRecord sequence = ref.getSequenceDictionary().getSequence(contig);
        if (sequence == null) {
            throw new IllegalArgumentException("unknown contig id " + contig);
        }
        if (start <= 0) {
            throw new IllegalArgumentException("the start must be greater than 0");
        }
        if (end > sequence.getSequenceLength()) {
            throw new IllegalArgumentException("the end must be less than the sequence length or equal to");
        }
        SimpleInterval interval = new SimpleInterval(loc);
        ReferenceBases referenceBases = new ReferenceBases(ref.queryAndPrefetch(interval).getBases(), interval);
        List<GATKRead> reads = Utils.stream(aln.query(interval)).collect(Collectors.toList());
        return IntervalPileup.of(reads, referenceBases);
    }

    public static IntervalPileup of(List<GATKRead> reads, ReferenceBases referenceBases) {
        Utils.nonNull(reads);
        Utils.nonNull(referenceBases);
        if (reads.isEmpty()) {
            return new EmptyIntervalPileup(referenceBases);
        }
        return new ByteMapIntervalPileup(referenceBases, reads);
    }

    public static interface Insert {
        public int column();

        public int length();

        public byte[] bases();

        public byte[] quals();

        public boolean equals(Object var1);

        public int hashCode();

        public int copyBases(int var1, byte[] var2, int var3, int var4);

        default public int copyBases(int offset, byte[] dest, int destOffset) {
            return this.copyBases(offset, dest, destOffset, Integer.MAX_VALUE);
        }

        default public int copyBases(byte[] dest) {
            return this.copyBases(0, dest, 0, Integer.MAX_VALUE);
        }

        public int copyQuals(int var1, byte[] var2, int var3, int var4);

        default public int copyQuals(int offset, byte[] dest, int destOffset) {
            return this.copyQuals(offset, dest, destOffset, Integer.MAX_VALUE);
        }

        default public int copyQuals(byte[] dest) {
            return this.copyQuals(0, dest, 0, Integer.MAX_VALUE);
        }
    }

    public static interface Element {
        public GATKRead read();

        public int row();

        public int minColumn();

        public int maxColumn();

        public Insert insertAt(int var1);

        public List<Insert> inserts();

        default public List<Insert> inserts(int firstColumn, int lastColumn) {
            int i;
            if (lastColumn < firstColumn) {
                return Collections.emptyList();
            }
            List<Insert> all = this.inserts();
            if (all.isEmpty()) {
                return Collections.emptyList();
            }
            if (all.size() == 1) {
                int column = all.get(0).column();
                return column >= firstColumn && column <= lastColumn ? all : Collections.emptyList();
            }
            for (i = 0; i < all.size() && all.get(i).column() < firstColumn; ++i) {
            }
            int j = i;
            int k = 0;
            while (j < all.size() && all.get(j).column() <= lastColumn) {
                ++j;
                ++k;
            }
            if (k == 0) {
                return Collections.emptyList();
            }
            if (k == 1) {
                return Collections.singletonList(all.get(i));
            }
            return all.subList(i, i + k);
        }

        public boolean hasInsertAt(int var1);

        public int insertSize(int var1);

        public int copyInsertBases(int var1, byte[] var2, int var3, int var4);

        public int copyInsertQuals(int var1, byte[] var2, int var3, int var4);

        public byte[] insertQualsAt(int var1);

        public byte[] insertBasesAt(int var1);

        public byte baseAt(int var1);

        public byte qualAt(int var1);
    }
}

