/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import htsjdk.samtools.util.Log;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.broadinstitute.hellbender.exceptions.GATKException;

public class LoggingUtils {
    private static BiMap<Log.LogLevel, Level> loggingLevelNamespaceMap = EnumHashBiMap.create(Log.LogLevel.class);
    private static BiMap<Log.LogLevel, java.util.logging.Level> javaUtilLevelNamespaceMap;

    static Log.LogLevel levelFromLog4jLevel(Level log4jLevel) {
        return (Log.LogLevel)loggingLevelNamespaceMap.inverse().get((Object)log4jLevel);
    }

    public static Level levelToLog4jLevel(Log.LogLevel picardLevel) {
        return (Level)loggingLevelNamespaceMap.get((Object)picardLevel);
    }

    private static void setJavaUtilLoggingLevel(Log.LogLevel verbosity) {
        Logger topLogger = Logger.getLogger("");
        Handler consoleHandler = null;
        for (Handler handler : topLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            consoleHandler = handler;
            break;
        }
        if (consoleHandler == null) {
            consoleHandler = new ConsoleHandler();
            topLogger.addHandler(consoleHandler);
        }
        consoleHandler.setLevel(LoggingUtils.levelToJavaUtilLevel(verbosity));
    }

    private static java.util.logging.Level levelToJavaUtilLevel(Log.LogLevel picardLevel) {
        return (java.util.logging.Level)javaUtilLevelNamespaceMap.get((Object)picardLevel);
    }

    public static void setLoggingLevel(Log.LogLevel verbosity) {
        Log.setGlobalLogLevel((Log.LogLevel)verbosity);
        LoggingUtils.setLog4JLoggingLevel(verbosity);
        LoggingUtils.setJavaUtilLoggingLevel(verbosity);
        LoggingUtils.setMinLogLoggingLevel(verbosity);
    }

    private static void setLog4JLoggingLevel(Log.LogLevel verbosity) {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration loggerContextConfig = loggerContext.getConfiguration();
        String contextClassName = LoggingUtils.class.getName();
        LoggerConfig loggerConfig = loggerContextConfig.getLoggerConfig(contextClassName);
        loggerConfig.setLevel(LoggingUtils.levelToLog4jLevel(verbosity));
        loggerContext.updateLoggers();
    }

    private static void setMinLogLoggingLevel(Log.LogLevel verbosity) {
        switch (verbosity) {
            case DEBUG: {
                com.esotericsoftware.minlog.Log.DEBUG();
                break;
            }
            case INFO: {
                com.esotericsoftware.minlog.Log.INFO();
                break;
            }
            case WARNING: {
                com.esotericsoftware.minlog.Log.WARN();
                break;
            }
            case ERROR: {
                com.esotericsoftware.minlog.Log.ERROR();
                break;
            }
            default: {
                throw new GATKException("This log level is not implemented properly: " + verbosity);
            }
        }
    }

    static {
        loggingLevelNamespaceMap.put((Object)Log.LogLevel.ERROR, (Object)Level.ERROR);
        loggingLevelNamespaceMap.put((Object)Log.LogLevel.WARNING, (Object)Level.WARN);
        loggingLevelNamespaceMap.put((Object)Log.LogLevel.INFO, (Object)Level.INFO);
        loggingLevelNamespaceMap.put((Object)Log.LogLevel.DEBUG, (Object)Level.DEBUG);
        javaUtilLevelNamespaceMap = EnumHashBiMap.create(Log.LogLevel.class);
        javaUtilLevelNamespaceMap.put((Object)Log.LogLevel.ERROR, (Object)java.util.logging.Level.SEVERE);
        javaUtilLevelNamespaceMap.put((Object)Log.LogLevel.WARNING, (Object)java.util.logging.Level.WARNING);
        javaUtilLevelNamespaceMap.put((Object)Log.LogLevel.INFO, (Object)java.util.logging.Level.INFO);
        javaUtilLevelNamespaceMap.put((Object)Log.LogLevel.DEBUG, (Object)java.util.logging.Level.FINEST);
    }
}

