/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;

final class MRUCachingSAMSequenceDictionary {
    private final SAMSequenceDictionary dict;
    SAMSequenceRecord lastSSR = null;
    String lastContig = "";
    int lastIndex = -1;

    public MRUCachingSAMSequenceDictionary(SAMSequenceDictionary dict) {
        Utils.nonNull(Boolean.valueOf(dict == null), "Dictionary cannot be null");
        Utils.validateArg(!dict.isEmpty(), "Dictionary cannot have size zero");
        this.dict = dict;
    }

    public SAMSequenceDictionary getDictionary() {
        return this.dict;
    }

    public final boolean hasContig(String contig) {
        return contig.equals(this.lastContig) || this.dict.getSequence(contig) != null;
    }

    public final SAMSequenceRecord getSequence(String contig) {
        if (this.isCached(contig)) {
            return this.lastSSR;
        }
        return this.updateCache(contig, -1);
    }

    public final SAMSequenceRecord getSequence(int index) {
        if (this.isCached(index)) {
            return this.lastSSR;
        }
        return this.updateCache(null, index);
    }

    public final int getSequenceIndex(String contig) {
        if (!this.isCached(contig)) {
            this.updateCache(contig, -1);
        }
        return this.lastIndex;
    }

    protected boolean isCached(String contig) {
        return contig.equals(this.lastContig);
    }

    protected boolean isCached(int index) {
        return this.lastIndex == index;
    }

    private SAMSequenceRecord updateCache(String contig, int index) {
        SAMSequenceRecord rec;
        SAMSequenceRecord sAMSequenceRecord = rec = contig == null ? this.dict.getSequence(index) : this.dict.getSequence(contig);
        if (rec == null) {
            throw new GATKException("BUG: requested unknown contig=" + contig + " index=" + index);
        }
        this.lastSSR = rec;
        this.lastContig = rec.getSequenceName();
        this.lastIndex = rec.getSequenceIndex();
        return rec;
    }
}

