/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.util.stream.IntStream;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.broadinstitute.hellbender.utils.Utils;

public class MatrixSummaryUtils {
    private MatrixSummaryUtils() {
    }

    public static double[] getColumnMedians(RealMatrix m) {
        Utils.nonNull(m, "Cannot calculate medians on a null matrix.");
        Median medianCalculator = new Median();
        return IntStream.range(0, m.getColumnDimension()).boxed().mapToDouble(i -> medianCalculator.evaluate(m.getColumn(i.intValue()))).toArray();
    }

    public static double[] getRowMedians(RealMatrix m) {
        Utils.nonNull(m, "Cannot calculate medians on a null matrix.");
        Median medianCalculator = new Median();
        return IntStream.range(0, m.getRowDimension()).boxed().mapToDouble(i -> medianCalculator.evaluate(m.getRow(i.intValue()))).toArray();
    }

    public static double[] getRowVariances(RealMatrix m) {
        Utils.nonNull(m, "Cannot calculate medians on a null matrix.");
        StandardDeviation std = new StandardDeviation();
        return IntStream.range(0, m.getRowDimension()).boxed().mapToDouble(i -> Math.pow(std.evaluate(m.getRow(i.intValue())), 2.0)).toArray();
    }
}

