/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import htsjdk.samtools.SAMFileHeader;
import java.util.Arrays;
import java.util.LinkedList;
import org.broadinstitute.hellbender.utils.SequencerFlowClass;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public enum NGSPlatform {
    ILLUMINA(SequencerFlowClass.DISCRETE, "ILLUMINA", "SLX", "SOLEXA"),
    SOLID(SequencerFlowClass.DISCRETE, "SOLID"),
    LS454(SequencerFlowClass.FLOW, "454", "LS454"),
    COMPLETE_GENOMICS(SequencerFlowClass.DISCRETE, "COMPLETE"),
    PACBIO(SequencerFlowClass.DISCRETE, "PACBIO"),
    ION_TORRENT(SequencerFlowClass.FLOW, "IONTORRENT"),
    CAPILLARY(SequencerFlowClass.OTHER, "CAPILLARY"),
    HELICOS(SequencerFlowClass.OTHER, "HELICOS"),
    UNKNOWN(SequencerFlowClass.OTHER, "UNKNOWN");

    protected final String[] BAM_PL_NAMES;
    protected final SequencerFlowClass sequencerType;

    private NGSPlatform(SequencerFlowClass type, String ... BAM_PL_NAMES) {
        if (BAM_PL_NAMES.length == 0) {
            throw new IllegalStateException("Platforms must have at least one name");
        }
        for (int i = 0; i < BAM_PL_NAMES.length; ++i) {
            BAM_PL_NAMES[i] = BAM_PL_NAMES[i].toUpperCase();
        }
        this.BAM_PL_NAMES = BAM_PL_NAMES;
        this.sequencerType = type;
    }

    public final String getDefaultPlatform() {
        return this.BAM_PL_NAMES[0];
    }

    public final SequencerFlowClass getSequencerType() {
        return this.sequencerType;
    }

    public static NGSPlatform fromRead(GATKRead read, SAMFileHeader header) {
        Utils.nonNull(read, "read cannot be null");
        return NGSPlatform.fromReadGroupPL(ReadUtils.getPlatform(read, header));
    }

    public static NGSPlatform fromReadGroupPL(String plFromRG) {
        if (plFromRG == null) {
            return UNKNOWN;
        }
        String pl = plFromRG.toUpperCase();
        for (NGSPlatform ngsPlatform : NGSPlatform.values()) {
            for (String bamPLName : ngsPlatform.BAM_PL_NAMES) {
                if (!pl.contains(bamPLName)) continue;
                return ngsPlatform;
            }
        }
        return UNKNOWN;
    }

    public static boolean isKnown(String platform) {
        return NGSPlatform.fromReadGroupPL(platform) != UNKNOWN;
    }

    public static String knownPlatformsString() {
        LinkedList<String> names = new LinkedList<String>();
        for (NGSPlatform pl : NGSPlatform.values()) {
            names.addAll(Arrays.asList(pl.BAM_PL_NAMES));
        }
        return Utils.join(",", names);
    }
}

