/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.io.File;
import org.apache.commons.lang3.SystemUtils;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public final class NativeUtils {
    private NativeUtils() {
    }

    public static boolean runningOnPPCArchitecture() {
        return NativeUtils.runningOnArchitecture("ppc64le");
    }

    public static boolean runningOnArchitecture(String architecture) {
        Utils.nonNull(architecture);
        String archtectureString = SystemUtils.OS_ARCH;
        return archtectureString != null && archtectureString.equals(architecture);
    }

    public static boolean runningOnMac() {
        return SystemUtils.IS_OS_MAC;
    }

    public static boolean runningOnLinux() {
        return SystemUtils.IS_OS_LINUX;
    }

    public static boolean loadLibraryFromClasspath(String libraryPathInJar) {
        Utils.nonNull(libraryPathInJar);
        Utils.validateArg(libraryPathInJar.startsWith("/"), "library path in jar must be absolute");
        try {
            File extractedLibrary = IOUtils.writeTempResourceFromPath(libraryPathInJar, NativeUtils.class);
            extractedLibrary.deleteOnExit();
            System.load(extractedLibrary.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError | UserException e) {
            return false;
        }
        return true;
    }
}

