/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;

public class NaturalLogUtils {
    public static final double LOG_ONE_HALF = FastMath.log((double)0.5);
    public static final double LOG_ONE_THIRD = FastMath.log((double)0.3333333333333333);
    private static final double LOG1MEXP_THRESHOLD = Math.log(0.5);
    private static final double PHRED_TO_LOG_ERROR_PROB_FACTOR = -Math.log(10.0) / 10.0;
    private static final double[] qualToLogProbCache = new IndexRange(0, 255).mapToDouble(n -> NaturalLogUtils.log1mexp(NaturalLogUtils.qualToLogErrorProb(n)));

    private NaturalLogUtils() {
    }

    public static double[] normalizeFromLogToLinearSpace(double[] array) {
        return NaturalLogUtils.normalizeLog(Utils.nonNull(array), false, true);
    }

    public static double[] normalizeLog(double[] array) {
        return NaturalLogUtils.normalizeLog(Utils.nonNull(array), true, true);
    }

    public static double[] normalizeLog(double[] array, boolean takeLogOfOutput, boolean inPlace) {
        double logSum = NaturalLogUtils.logSumExp(Utils.nonNull(array));
        double[] result = inPlace ? MathUtils.applyToArrayInPlace(array, x -> x - logSum) : MathUtils.applyToArray(array, x -> x - logSum);
        return takeLogOfOutput ? result : MathUtils.applyToArrayInPlace(result, Math::exp);
    }

    public static double logSumExp(double ... logValues) {
        Utils.nonNull(logValues);
        int maxElementIndex = MathUtils.maxElementIndex(logValues);
        double maxValue = logValues[maxElementIndex];
        if (maxValue == Double.NEGATIVE_INFINITY) {
            return maxValue;
        }
        double sum = 1.0;
        for (int i = 0; i < logValues.length; ++i) {
            double curVal = logValues[i];
            if (i == maxElementIndex || curVal == Double.NEGATIVE_INFINITY) continue;
            double scaled_val = curVal - maxValue;
            sum += Math.exp(scaled_val);
        }
        if (Double.isNaN(sum) || sum == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("log10 p: Values must be non-infinite and non-NAN");
        }
        return maxValue + (sum != 1.0 ? Math.log(sum) : 0.0);
    }

    public static double log1mexp(double a) {
        if (a > 0.0) {
            return Double.NaN;
        }
        if (a == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return a < LOG1MEXP_THRESHOLD ? Math.log1p(-Math.exp(a)) : Math.log(-Math.expm1(a));
    }

    public static double[] posteriors(double[] logPriors, double[] logLikelihoods) {
        return NaturalLogUtils.normalizeFromLogToLinearSpace(MathArrays.ebeAdd((double[])logPriors, (double[])logLikelihoods));
    }

    public static double qualToLogErrorProb(byte qual) {
        return NaturalLogUtils.qualToLogErrorProb(qual & 0xFF);
    }

    public static double qualToLogErrorProb(double qual) {
        Utils.validateArg(qual >= 0.0, () -> "qual must be >= 0.0 but got " + qual);
        return qual * PHRED_TO_LOG_ERROR_PROB_FACTOR;
    }

    public static double qualToLogProb(byte qual) {
        return qualToLogProbCache[qual & 0xFF];
    }

    public static double logSumLog(double a, double b) {
        return a > b ? a + FastMath.log((double)(1.0 + FastMath.exp((double)(b - a)))) : b + FastMath.log((double)(1.0 + FastMath.exp((double)(a - b))));
    }
}

