/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;

public enum Nucleotide {
    A(1),
    C(2),
    G(4),
    T(8),
    R(A, G),
    Y(C, T),
    S(C, G),
    W(A, T),
    K(G, T),
    M(A, C),
    B(C, G, T),
    D(A, G, T),
    H(A, C, T),
    V(A, C, G),
    N(A, C, G, T),
    X(new Nucleotide[0]);

    public static final Nucleotide U;
    public static final Nucleotide ADENINE;
    public static final Nucleotide CYTOSINE;
    public static final Nucleotide GUANINE;
    public static final Nucleotide THYMINE;
    public static final Nucleotide URACIL;
    public static final Nucleotide STRONG;
    public static final Nucleotide WEAK;
    public static final Nucleotide PURINE;
    public static final Nucleotide PYRIMIDINE;
    public static final Nucleotide AMINO;
    public static final Nucleotide KETO;
    public static final Nucleotide ANY;
    public static final Nucleotide INVALID;
    public static final Set<Nucleotide> STANDARD_BASES;
    private static final int NUMBER_OF_CONSTANTS;
    private static final Nucleotide[] baseToValue;
    private static final Nucleotide[] maskToValue;
    private static final int[] baseToOrdinal;
    private final int mask;
    private final boolean isStandard;
    private Nucleotide complement;
    private Nucleotide transition;
    private Nucleotide transversion;
    private final byte lowerCaseByteEncoding;
    private final String lowerCaseStringEncoding;
    private final char lowerCaseCharEncoding;
    private final byte upperCaseByteEncoding;
    private final char upperCaseCharEncoding;

    private Nucleotide(int mask) {
        this.mask = mask;
        this.isStandard = Integer.bitCount(mask & 0xF) == 1;
        this.lowerCaseByteEncoding = (byte)Character.toLowerCase(this.name().charAt(0));
        this.lowerCaseCharEncoding = Character.toLowerCase(this.name().charAt(0));
        this.upperCaseByteEncoding = (byte)Character.toUpperCase(this.name().charAt(0));
        this.upperCaseCharEncoding = Character.toUpperCase(this.name().charAt(0));
        this.lowerCaseStringEncoding = this.name().toLowerCase();
    }

    private Nucleotide(Nucleotide ... nucs) {
        this(Arrays.stream(nucs).mapToInt(nuc -> nuc.mask).reduce((a, b) -> a | b).orElse(0));
    }

    public byte encodeAsByte(boolean upperCase) {
        return upperCase ? this.upperCaseByteEncoding : this.lowerCaseByteEncoding;
    }

    public char encodeAsChar(boolean upperCase) {
        return upperCase ? this.upperCaseCharEncoding : this.lowerCaseCharEncoding;
    }

    public byte encodeAsByte() {
        return this.upperCaseByteEncoding;
    }

    public char encodeAsChar() {
        return this.upperCaseCharEncoding;
    }

    public String encodeAsString() {
        return this.toString();
    }

    public String encodeAsString(boolean upperCase) {
        return upperCase ? this.toString() : this.lowerCaseStringEncoding;
    }

    public static Nucleotide decode(byte base) {
        return baseToValue[base & 0xFF];
    }

    public static Nucleotide decode(char ch) {
        if ((ch & 0xFFFFFF80) == 0) {
            return baseToValue[ch & 0x7F];
        }
        return INVALID;
    }

    public static Nucleotide decode(CharSequence seq) {
        Utils.nonNull(seq, "the input character sequence must not be null");
        if (seq.length() != 1) {
            throw new IllegalArgumentException("the input character sequence must be exactly one character long");
        }
        return Nucleotide.decode(seq.charAt(0));
    }

    public boolean isStandard() {
        return this.isStandard;
    }

    public boolean isAmbiguous() {
        return !this.isStandard && this != INVALID;
    }

    public boolean isValid() {
        return this != INVALID;
    }

    public boolean includes(Nucleotide other) {
        Utils.nonNull(other);
        return other != INVALID && (this.mask & other.mask) == other.mask;
    }

    public boolean includes(byte b) {
        return this.includes(Nucleotide.decode(b));
    }

    public Nucleotide intersect(Nucleotide other) {
        Utils.nonNull(other, "the other nucleotide cannot be null");
        return maskToValue[this.mask & other.mask];
    }

    public static boolean intersect(byte a, byte b) {
        return (Nucleotide.baseToValue[0xFF & a].mask & Nucleotide.baseToValue[0xFF & b].mask) != 0;
    }

    public static boolean same(byte a, byte b) {
        return baseToValue[a & 0xFF] == baseToValue[b & 0xFF] && baseToValue[a & 0xFF] != INVALID;
    }

    public boolean same(Nucleotide other) {
        return this == other && this != INVALID;
    }

    public Nucleotide complement() {
        return this.complement;
    }

    public static byte complement(byte b, boolean upperCase) {
        Nucleotide compl = Nucleotide.baseToValue[b & 0xFF].complement;
        return compl != INVALID ? (upperCase ? compl.upperCaseByteEncoding : compl.lowerCaseByteEncoding) : (byte)(upperCase ? Character.toUpperCase(b) : Character.toLowerCase(b));
    }

    public static byte complement(byte b) {
        Nucleotide compl = Nucleotide.baseToValue[b & 0xFF].complement;
        return compl != INVALID ? (Character.isUpperCase(b) ? compl.upperCaseByteEncoding : compl.lowerCaseByteEncoding) : b;
    }

    public Nucleotide transition() {
        return this.transition;
    }

    public Nucleotide transversion() {
        return this.transversion;
    }

    private void finalizeInitialization() {
        int complementMask = ((this.mask & Nucleotide.A.mask) != 0 ? Nucleotide.T.mask : 0) | ((this.mask & Nucleotide.T.mask) != 0 ? Nucleotide.A.mask : 0) | ((this.mask & Nucleotide.C.mask) != 0 ? Nucleotide.G.mask : 0) | ((this.mask & Nucleotide.G.mask) != 0 ? Nucleotide.C.mask : 0);
        this.complement = maskToValue[complementMask];
        int transversionMask = ((this.mask & Nucleotide.PURINE.mask) != 0 ? Nucleotide.PYRIMIDINE.mask : 0) | ((this.mask & Nucleotide.PYRIMIDINE.mask) != 0 ? Nucleotide.PURINE.mask : 0);
        this.transversion = maskToValue[transversionMask];
        int transitionMask = ((this.mask & Nucleotide.A.mask) != 0 ? Nucleotide.G.mask : 0) | ((this.mask & Nucleotide.G.mask) != 0 ? Nucleotide.A.mask : 0) | ((this.mask & Nucleotide.C.mask) != 0 ? Nucleotide.T.mask : 0) | ((this.mask & Nucleotide.T.mask) != 0 ? Nucleotide.C.mask : 0);
        this.transition = maskToValue[transitionMask];
    }

    public Nucleotide transversion(boolean strong) {
        return this.transversion.intersect(strong ? STRONG : WEAK);
    }

    static /* synthetic */ int access$000() {
        return NUMBER_OF_CONSTANTS;
    }

    static {
        U = T;
        ADENINE = A;
        CYTOSINE = C;
        GUANINE = G;
        THYMINE = T;
        URACIL = U;
        STRONG = S;
        WEAK = W;
        PURINE = R;
        PYRIMIDINE = Y;
        AMINO = M;
        KETO = K;
        ANY = N;
        INVALID = X;
        STANDARD_BASES = Sets.immutableEnumSet((Enum)A, (Enum[])new Nucleotide[]{C, G, T});
        Nucleotide[] values = Nucleotide.values();
        NUMBER_OF_CONSTANTS = values.length;
        baseToValue = new Nucleotide[256];
        maskToValue = new Nucleotide[1 << STANDARD_BASES.size()];
        baseToOrdinal = new int[256];
        Arrays.fill((Object[])baseToValue, (Object)INVALID);
        Arrays.fill(baseToOrdinal, INVALID.ordinal());
        Nucleotide[] nucleotideArray = values;
        int n = nucleotideArray.length;
        for (int i = 0; i < n; ++i) {
            Nucleotide nucleotide = nucleotideArray[i];
            int lowerCaseIndex = nucleotide.lowerCaseByteEncoding & 0xFF;
            int upperCaseIndex = nucleotide.upperCaseByteEncoding & 0xFF;
            Nucleotide.maskToValue[nucleotide.mask] = nucleotide;
            Nucleotide.baseToValue[lowerCaseIndex] = Nucleotide.baseToValue[upperCaseIndex] = nucleotide;
            Nucleotide.baseToOrdinal[lowerCaseIndex] = Nucleotide.baseToOrdinal[upperCaseIndex] = nucleotide.ordinal();
        }
        Nucleotide.baseToValue[117] = Nucleotide.baseToValue[85] = U;
        Nucleotide.baseToOrdinal[117] = Nucleotide.baseToOrdinal[85] = U.ordinal();
        for (Nucleotide value : Nucleotide.values()) {
            value.finalizeInitialization();
        }
    }

    public static final class Counter {
        private final long[] counts = new long[Nucleotide.access$000()];

        public void add(Nucleotide nucleotide) {
            int n = Utils.nonNull(nucleotide).ordinal();
            this.counts[n] = this.counts[n] + 1L;
        }

        public void add(byte base) {
            int n = baseToOrdinal[base & 0xFF];
            this.counts[n] = this.counts[n] + 1L;
        }

        public void add(char base) {
            if ((base & 0xFFFFFF80) == 0) {
                int n = baseToOrdinal[base & 0x7F];
                this.counts[n] = this.counts[n] + 1L;
            } else {
                int n = INVALID.ordinal();
                this.counts[n] = this.counts[n] + 1L;
            }
        }

        public long get(Nucleotide nucleotide) {
            return this.counts[Utils.nonNull(nucleotide).ordinal()];
        }

        public final void addAll(byte ... bases) {
            Utils.nonNull(bases);
            for (byte base : bases) {
                int n = baseToOrdinal[base & 0xFF];
                this.counts[n] = this.counts[n] + 1L;
            }
        }

        public final void addAll(char ... bases) {
            Utils.nonNull(bases);
            for (char base : bases) {
                if ((base & 0xFF00) != 0) {
                    int n = INVALID.ordinal();
                    this.counts[n] = this.counts[n] + 1L;
                    continue;
                }
                int n = baseToOrdinal[base & 0xFF];
                this.counts[n] = this.counts[n] + 1L;
            }
        }

        public final void addAll(CharSequence bases) {
            Utils.nonNull(bases);
            for (int i = 0; i < bases.length(); ++i) {
                char base = bases.charAt(i);
                if ((base & 0xFF00) != 0) {
                    int n = INVALID.ordinal();
                    this.counts[n] = this.counts[n] + 1L;
                    continue;
                }
                int n = baseToOrdinal[base & 0xFF];
                this.counts[n] = this.counts[n] + 1L;
            }
        }

        public void clear() {
            Arrays.fill(this.counts, 0L);
        }

        public long sum() {
            return MathUtils.sum(this.counts);
        }
    }
}

