/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils;

import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.univariate.BrentOptimizer;
import org.apache.commons.math3.optim.univariate.SearchInterval;
import org.apache.commons.math3.optim.univariate.UnivariateObjectiveFunction;
import org.apache.commons.math3.optim.univariate.UnivariatePointValuePair;

public final class OptimizationUtils {
    protected static final MaxEval DEFAULT_MAX_EVAL = new MaxEval(1000);
    private static final double DEFAULT_RELATIVE_TOLERANCE = 0.001;
    private static final double DEFAULT_ABSOLUTE_TOLERANCE = 0.001;
    protected static final BrentOptimizer DEFAULT_OPTIMIZER = new BrentOptimizer(0.001, 0.001);
    private static final double DEFAULT_EPSILON_FOR_NUMERIC_DERIVATIVES = 1.0E-5;
    private static final double DEFAULT_DERIVATIVE_THRESHOLD = 1.0E-8;

    private OptimizationUtils() {
    }

    public static double argmax(Function<Double, Double> function, double min, double max, double guess) {
        return OptimizationUtils.max(function, min, max, guess).getPoint();
    }

    public static UnivariatePointValuePair max(Function<Double, Double> function, double min, double max, double guess) {
        SearchInterval interval = new SearchInterval(min, max, guess);
        OptimizationData[] optimizationDataArray = new OptimizationData[4];
        optimizationDataArray[0] = new UnivariateObjectiveFunction(function::apply);
        optimizationDataArray[1] = GoalType.MAXIMIZE;
        optimizationDataArray[2] = interval;
        optimizationDataArray[3] = DEFAULT_MAX_EVAL;
        return DEFAULT_OPTIMIZER.optimize(optimizationDataArray);
    }

    public static UnivariatePointValuePair max(DoubleUnaryOperator function, double min, double max, double guess, double relativeTolerance, double absoluteTolerance, int maxEvaluations) {
        BrentOptimizer optimizer = new BrentOptimizer(relativeTolerance, absoluteTolerance);
        SearchInterval interval = new SearchInterval(min, max, guess);
        OptimizationData[] optimizationDataArray = new OptimizationData[4];
        optimizationDataArray[0] = new UnivariateObjectiveFunction(function::applyAsDouble);
        optimizationDataArray[1] = GoalType.MAXIMIZE;
        optimizationDataArray[2] = interval;
        optimizationDataArray[3] = new MaxEval(maxEvaluations);
        return optimizer.optimize(optimizationDataArray);
    }

    public static double singleNewtonArgmaxUpdate(Function<Double, Double> function, double min, double max, double guess, double epsilon, double derivativeThreshold) {
        double fx = function.apply(guess);
        double fxPlusEps = function.apply(guess + epsilon);
        double fxMinusEps = function.apply(guess - epsilon);
        double secondDerivative = (fxPlusEps + fxMinusEps - 2.0 * fx) / (epsilon * epsilon);
        double firstDerivative = (fxPlusEps - fxMinusEps) / (2.0 * epsilon);
        double argmax = guess - firstDerivative / secondDerivative;
        if (Math.abs(firstDerivative) < derivativeThreshold) {
            return guess;
        }
        return argmax < min ? min : (argmax > max ? max : argmax);
    }

    public static double singleNewtonArgmaxUpdate(Function<Double, Double> function, double min, double max, double guess) {
        return OptimizationUtils.singleNewtonArgmaxUpdate(function, min, max, guess, 1.0E-5, 1.0E-8);
    }
}

